/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalInteractiveCommand {
    private static final Logger log = LoggerFactory.getLogger(LocalInteractiveCommand.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(3, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadFactoryBuilder().setUncaughtExceptionHandler((t, e) -> log.error("execute error", e)).setNameFormat("command-%d").build());
    private final String[] startCommands;
    private final Queue<Pair<String, String>> interactiveCommands;
    private final String interactiveCommandOverSign;
    private final boolean canPrintCommand;
    private final boolean canPrintOutput;
    private final StringBuilder standOutput = new StringBuilder();
    private final StringBuilder errorOutput = new StringBuilder();
    private final CountDownLatch wait = new CountDownLatch(2);
    private OutputStream out;
    private boolean isStart = false;
    private boolean mergeCommand = false;
    private boolean isRegisterHook = false;

    public LocalInteractiveCommand(String startCommand) {
        this(new String[]{startCommand});
        this.mergeCommand = true;
    }

    public LocalInteractiveCommand(String[] startCommands) {
        this(startCommands, new LinkedList<Pair<String, String>>());
    }

    public LocalInteractiveCommand(String[] startCommands, Queue<Pair<String, String>> interactiveCommands) {
        this(startCommands, interactiveCommands, "\n");
    }

    public LocalInteractiveCommand(String[] startCommands, Queue<Pair<String, String>> interactiveCommands, String interactiveCommandOverSign) {
        this(startCommands, interactiveCommands, interactiveCommandOverSign, true, true);
    }

    public void syncStart() throws IOException {
        if (this.isStart) {
            log.warn("this command is start.");
            return;
        }
        try {
            this.executeCommand();
        }
        finally {
            this.finishCommand();
        }
    }

    public synchronized void asyncStart() {
        if (this.isStart) {
            log.warn("this command is start.");
            return;
        }
        this.isStart = true;
        EXECUTOR_SERVICE.execute(() -> {
            try {
                this.executeCommand();
            }
            catch (IOException e) {
                log.error("execute command error", (Throwable)e);
            }
            finally {
                this.finishCommand();
            }
        });
    }

    public boolean isOver() {
        return this.wait.getCount() == 0L;
    }

    private void executeCommand() throws IOException {
        if (this.canPrintCommand) {
            log.info("execute command: {}", (Object)Arrays.toString(this.startCommands));
        }
        Process process = this.getProcess();
        this.registerShutdownHook(process);
        try (InputStream standStream = process.getInputStream();
             InputStream errorStream = process.getErrorStream();
             OutputStream outputStream = process.getOutputStream();){
            this.out = outputStream;
            new Thread(() -> this.readAndWrite(standStream, "stand")).start();
            new Thread(() -> this.readAndWrite(errorStream, "error")).start();
            this.wait.await();
        }
        catch (IOException | InterruptedException e) {
            this.finishCommand();
            log.error("execute command error", (Throwable)e);
        }
    }

    private void finishCommand() {
        this.wait.countDown();
        this.wait.countDown();
    }

    private void registerShutdownHook(Process process) {
        if (this.isRegisterHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(process::destroy));
        }
    }

    private Process getProcess() throws IOException {
        if (this.mergeCommand || this.startCommands.length == 1) {
            return Runtime.getRuntime().exec(String.join((CharSequence)",", this.startCommands));
        }
        return Runtime.getRuntime().exec(this.startCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndWrite(InputStream in, String type) {
        log.info("read output from {}", (Object)type);
        StringBuilder result = "stand".equals(type) ? this.standOutput : this.errorOutput;
        byte[] temp = new byte[2048];
        try {
            int len;
            while ((len = in.read(temp)) > -1) {
                String cur = new String(temp, 0, len, "gbk");
                if (this.canPrintOutput) {
                    log.info("read from {}: {}", (Object)type, (Object)cur);
                }
                result.append(cur);
                if (!CollectionUtils.isNotEmpty(this.interactiveCommands)) continue;
                this.write(cur);
            }
        }
        catch (Throwable e) {
            log.error("exe generate command read error.", e);
        }
        finally {
            this.wait.countDown();
        }
    }

    public synchronized void manalWrite(String command) throws IOException {
        if (this.isOver()) {
            log.warn("command thread is over, can't execute command");
            return;
        }
        if (CollectionUtils.isNotEmpty(this.interactiveCommands)) {
            log.warn("have interactive command, can't execute command");
            return;
        }
        this.writeCommand(command);
    }

    private synchronized void write(String result) throws IOException {
        if (this.interactiveCommands.isEmpty()) {
            return;
        }
        Pair<String, String> needExecuteCommand = this.interactiveCommands.peek();
        if (result.trim().endsWith((String)needExecuteCommand.getKey())) {
            this.interactiveCommands.poll();
            if (this.canPrintCommand) {
                log.info("input command: {}", needExecuteCommand.getValue());
            }
            this.writeCommand((String)needExecuteCommand.getValue() + this.interactiveCommandOverSign);
        }
    }

    private void writeCommand(String needExecuteCommand) throws IOException {
        if (needExecuteCommand == null) {
            log.error("need execute command is null");
            return;
        }
        this.out.write(needExecuteCommand.getBytes(Charset.defaultCharset()));
        this.out.flush();
    }

    public String getStandOutput() {
        return this.standOutput.toString();
    }

    public String getErrorOutput() {
        return this.errorOutput.toString();
    }

    public LocalInteractiveCommand(String[] startCommands, Queue<Pair<String, String>> interactiveCommands, String interactiveCommandOverSign, boolean canPrintCommand, boolean canPrintOutput) {
        this.startCommands = startCommands;
        this.interactiveCommands = interactiveCommands;
        this.interactiveCommandOverSign = interactiveCommandOverSign;
        this.canPrintCommand = canPrintCommand;
        this.canPrintOutput = canPrintOutput;
    }

    public void setMergeCommand(boolean mergeCommand) {
        this.mergeCommand = mergeCommand;
    }

    public void setRegisterHook(boolean isRegisterHook) {
        this.isRegisterHook = isRegisterHook;
    }
}

