/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.IpUtils;
import com.huawei.smartkit.drop.util.OsCmdUtils;
import com.huawei.smartkit.drop.util.StringUtils;
import com.huawei.smartkit.drop.util.SystemEnvUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtil {
    private static final Logger log = LoggerFactory.getLogger(NetUtil.class);

    public static boolean isHostCanConnect(String host, int port, int timeout) {
        return NetUtil.isHostConnectable(host, port, timeout * 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHostConnectable(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("host not avalable:{} {}", new Object[]{host, port, e});
            return NetUtil.pingHost(host, " -n ", String.valueOf(1));
        }
    }

    public static boolean pingHost(String host, String ... params) {
        String ret = "";
        ret = SystemEnvUtil.isWindowsOs() ? OsCmdUtils.executeCmd(NetUtil.getPingCmdForWindows(host, params)) : OsCmdUtils.executeCmd(NetUtil.getPingCmdForLinux(host));
        boolean canPinged = NetUtil.checkLink(ret, host);
        if (!canPinged) {
            log.error("Result of ping {} : {}", (Object)StringUtils.getCleanMessage(host), (Object)ret);
        }
        return canPinged;
    }

    private static String getPingCmdForLinux(String host) {
        return NetUtil.getPingCmdWordsByIpType(host) + host + " -c 4";
    }

    private static String getPingCmdForWindows(String host, String ... params) {
        StringBuilder cmd = new StringBuilder("ping ").append(host);
        if (params != null) {
            cmd.append(" ");
            for (String param : params) {
                cmd.append(param).append(" ");
            }
        }
        return cmd.toString();
    }

    private static boolean checkLink(String ret, String ip) {
        if (StringUtils.isEmpty(ret)) {
            return false;
        }
        String[] rets = ret.split("\n");
        return Arrays.stream(rets).anyMatch(line -> NetUtil.checkLine(line, ip));
    }

    private static boolean checkLine(String ret, String ip) {
        if (StringUtils.isEmpty(ret)) {
            return false;
        }
        String lowRet = ret.toLowerCase(Locale.ROOT);
        if (lowRet.contains("ttl") || lowRet.contains("reply from")) {
            return true;
        }
        if (lowRet.contains("unreachable")) {
            return false;
        }
        return IpUtils.isValidIpV6(ip) && ret.contains("<");
    }

    private static String getPingCmdWordsByIpType(String ip) {
        return IpUtils.isValidIpV6(ip) ? "ping6 " : "ping ";
    }

    private NetUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

