/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsUtils {
    private static final Logger log = LoggerFactory.getLogger(OsUtils.class);

    public static long getDiskFreeSpace(String filePath) {
        File file = new File(filePath);
        try {
            long freeSpace;
            if (!file.exists()) {
                Path newPath = Files.createFile(file.toPath(), new FileAttribute[0]);
                freeSpace = file.getFreeSpace();
                Files.delete(newPath);
            } else {
                freeSpace = file.getFreeSpace();
            }
            log.info("freeSpace size:{}", (Object)freeSpace);
            return freeSpace;
        }
        catch (IOException e) {
            log.error("create new file error", (Throwable)e);
            return -1L;
        }
    }

    private OsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

