/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.SystemEnvUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static String getString(String resourceBundle, String key) {
        return ResourceUtils.getString(resourceBundle, key, SystemEnvUtil.getLanguage());
    }

    public static String getString(String resourceBundle, String key, Locale language) {
        ResourceBundle resource = ResourceBundle.getBundle(resourceBundle, language);
        if (!resource.containsKey(key)) {
            log.warn("get resource failed, bundle: {}, key: {}", (Object)resourceBundle, (Object)key);
            return "";
        }
        return StringUtils.defaultString((String)resource.getString(key));
    }

    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

