/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    public static void closeStream(OutputStream output, InputStream input) {
        StreamUtils.closeResource(output, output);
        StreamUtils.closeResource(null, input);
    }

    public static void closeResource(Flushable flushable, Closeable closeable) {
        try {
            if (flushable != null) {
                flushable.flush();
            }
        }
        catch (IOException e) {
            log.error("failed to flush.", (Throwable)e);
        }
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            log.error("failed to close.", (Throwable)e);
        }
    }

    private StreamUtils() {
    }
}

