/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.LocalInteractiveCommand;
import com.huawei.smartkit.drop.util.StringUtils;
import com.huawei.smartkit.drop.util.file.FilePathUtils;
import java.io.File;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemEnvUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemEnvUtil.class);

    public static String getDefaultUserDir() throws IllegalArgumentException {
        return SystemEnvUtil.validPath(System.getProperty("user.dir"));
    }

    private static String validPath(String dir) {
        String tmp = dir.replace("\\\\", "");
        tmp = tmp.replace("/", "");
        tmp = tmp.replace(":", "");
        tmp = tmp.replace("\\(", "");
        String string = tmp = (tmp = tmp.replace("\\)", "")).contains("..") ? tmp : tmp.replace("\\.", "");
        if (tmp.matches("([^\\w-\\s]+)|(\\s{2,})")) {
            log.error("The tool path contains characters other than letters, digits, underscores, brackets, or spaces. Please change a tool path..");
            throw new IllegalArgumentException("user dir invalid.");
        }
        return FilePathUtils.getCanonicalPath(new File(dir)).orElseThrow(() -> new IllegalArgumentException("user dir invalid."));
    }

    public static String getDefaultUserHome() throws IllegalArgumentException {
        return SystemEnvUtil.validPath(System.getProperty("user.home"));
    }

    public static Locale getLanguage() {
        String language = System.getProperty("language");
        if (StringUtils.isEmpty(language)) {
            language = System.getenv("language");
        }
        if (StringUtils.isNotEmpty(language) && language.startsWith("zh")) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return Locale.ENGLISH;
    }

    public static boolean isEn() {
        return SystemEnvUtil.getLanguage() == Locale.ENGLISH;
    }

    public static boolean isWindowsOs() {
        String osName = System.getProperty("os.name");
        if (StringUtils.isEmpty(osName)) {
            log.warn("Can not get the system property of [os.name]");
            return false;
        }
        return osName.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    public static void startElectron(String url) {
        if (SystemEnvUtil.isWindowsOs()) {
            LocalInteractiveCommand startElectron = new LocalInteractiveCommand(String.format("electron\\ftd-browser.exe %s", url));
            startElectron.setRegisterHook(true);
            startElectron.asyncStart();
        }
    }

    private SystemEnvUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

