/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.entity.ZipLimit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private static final long MAX_FILE_SIZE;
    private static final long MAX_FILE_NUM;
    private static final long SINGLE_FILE_MAX_SIZE;

    private static long initSingleFileSize(Map<String, Long> config) {
        return config.getOrDefault("single.file.max.size", 0x500000L);
    }

    private static long initFileSize(Map<String, Long> config) {
        return config.getOrDefault("compress.max.size", 0x100000000L);
    }

    private static long initFileNum(Map<String, Long> config) {
        return config.getOrDefault("compress.max.num", 20000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Long> loadProperties() {
        try (InputStream inputStream = ZipUtils.class.getResourceAsStream("/zipconfig.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, Long> map = properties.keySet().stream().collect(Collectors.toMap(Object::toString, key -> Long.parseLong(properties.get(key).toString())));
            return map;
        }
        catch (IOException e) {
            log.error("load zip config error", (Throwable)e);
            return new HashMap<String, Long>();
        }
    }

    public static String getStringFromZip(File zipPath, String innerName) throws IOException, IllegalArgumentException {
        try (ZipFile zipFile = new ZipFile(zipPath);){
            Enumeration entries = zipFile.getEntries();
            ZipLimit zipLimit = new ZipLimit(SINGLE_FILE_MAX_SIZE, MAX_FILE_NUM);
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entries.nextElement();
                if (zipArchiveEntry.isDirectory()) {
                    zipLimit.increment(0L, 1L);
                    continue;
                }
                if (!zipArchiveEntry.getName().endsWith(innerName)) continue;
                zipLimit.increment(zipArchiveEntry.getSize(), 1L);
                String string = ZipUtils.readFromStream(zipFile, zipArchiveEntry);
                return string;
            }
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    private static String readFromStream(ZipFile zipFile, ZipArchiveEntry zipArchiveEntry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deCompressFile(File localFile, String toPath) throws IOException, IllegalArgumentException {
        try (ZipFile zipFile = new ZipFile(localFile);){
            Enumeration entries = zipFile.getEntries();
            ZipLimit zipLimit = new ZipLimit(MAX_FILE_SIZE, MAX_FILE_NUM);
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entries.nextElement();
                ZipUtils.unZipFile(zipArchiveEntry, zipFile, toPath, zipLimit);
            }
        }
    }

    private static void unZipFile(ZipArchiveEntry zipEntry, ZipFile zipFile, String toPath, ZipLimit zipLimit) throws IOException {
        if (zipEntry.isDirectory()) {
            zipLimit.increment(0L, 1L);
            new File(toPath, ZipUtils.filterZipEntryName(zipEntry.getName())).mkdirs();
            return;
        }
        zipLimit.increment(zipEntry.getSize(), 1L);
        File file = new File(toPath, ZipUtils.filterZipEntryName(zipEntry.getName()));
        ZipUtils.buildParentDir(file);
        ZipUtils.writeToLocal(zipEntry, zipFile, file);
    }

    private static void writeToLocal(ZipArchiveEntry zipEntry, ZipFile zipFile, File file) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
             BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int readLen;
            byte[] buf = new byte[1024];
            while ((readLen = ((InputStream)is).read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
            }
        }
    }

    private static void buildParentDir(File file) {
        File parentFile = file.getParentFile();
        if (Objects.nonNull(parentFile) && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    public static String filterZipEntryName(String name) {
        if (name.contains("../") || name.contains("..\\")) {
            log.warn("Unsafe file name {}.", (Object)name);
            return name.replaceAll("\\.\\./", "").replaceAll("\\.\\.\\\\", "");
        }
        return name;
    }

    private ZipUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Map<String, Long> config = ZipUtils.loadProperties();
        MAX_FILE_SIZE = ZipUtils.initFileSize(config);
        MAX_FILE_NUM = ZipUtils.initFileNum(config);
        SINGLE_FILE_MAX_SIZE = ZipUtils.initSingleFileSize(config);
    }
}

