/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util.file;

import com.huawei.smartkit.drop.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilePathUtils {
    private static final Logger log = LoggerFactory.getLogger(FilePathUtils.class);

    public static Optional<String> getCanonicalPath(@NotNull File file) {
        try {
            return Optional.of(file.getCanonicalPath());
        }
        catch (IOException exception) {
            log.warn("transfer [{}] to normal path error", (Object)file.getPath());
            return Optional.empty();
        }
    }

    public static Optional<String> getCanonicalPath(@NotNull String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            log.warn("current file path is empty");
            return Optional.empty();
        }
        return FilePathUtils.getCanonicalPath(new File(filePath));
    }

    private FilePathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

