/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util.sensitive;

import com.huawei.smartkit.drop.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SensitiveUtils {
    private static final Logger log = LoggerFactory.getLogger(SensitiveUtils.class);
    private static final String ANONYMIZATION_CHARACTER = "*";

    public static void cleanStr(String str) {
        if (StringUtils.isEmpty(str)) {
            return;
        }
        try {
            Field stringValue = String.class.getDeclaredField("value");
            stringValue.setAccessible(true);
            char[] pwdChar = (char[])stringValue.get(str);
            Arrays.fill(pwdChar, '\u0000');
            stringValue.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            log.error("Clean str Exception", (Throwable)e);
        }
    }

    public static void cleanObjectStringField(Object object, Field field) {
        if (field.getType() != String.class) {
            return;
        }
        try {
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            if (fieldValue instanceof String) {
                SensitiveUtils.cleanStr((String)fieldValue);
            }
            field.setAccessible(false);
        }
        catch (IllegalAccessException | SecurityException e) {
            log.error("Clean field Exception", (Throwable)e);
        }
    }

    @NotNull
    public static String anonymizeEmailAddresses(String customerMail) {
        if (StringUtils.isEmpty(customerMail)) {
            return "";
        }
        int index = customerMail.indexOf(64);
        StringBuilder anonymousAddr = new StringBuilder();
        if (index > 4) {
            anonymousAddr.append(customerMail, 0, 2);
            for (int i = 0; i < index - 4; ++i) {
                anonymousAddr.append(ANONYMIZATION_CHARACTER);
            }
            anonymousAddr.append(customerMail.substring(index - 2));
        } else {
            anonymousAddr.append(customerMail.charAt(0));
            for (int i = 0; i < index - 2; ++i) {
                anonymousAddr.append(ANONYMIZATION_CHARACTER);
            }
            anonymousAddr.append(customerMail.substring(index - 1));
        }
        return anonymousAddr.toString();
    }

    private SensitiveUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

