/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ComponentInstallDto;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ContainerNetwork;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.NicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.Node;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.NodePool;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.Quorum;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class EcontainerDeployParamEntity {
    @JSONField(serialize=false)
    private String path;
    @JSONField(serialize=false)
    private String adminPwd;
    @JSONField(name="nodepools")
    private List<NodePool> nodePools;
    private NicInfo manageNic;
    private NicInfo businessNic;
    private String name;
    private String version;
    private String managerControlSoftwareVersion;
    private String managerControlInitpasswd;
    private String managerControlTrapIp;
    private String osVersion;
    private boolean canAudit;
    private boolean masterSchedulable;
    private boolean multusEnable;
    private int imageRepoSize;
    private ContainerNetwork containerNetwork;
    private Quorum quorum;
    private List<String> dns;
    @JSONField(name="ntp")
    private List<String> ntpIp;
    private ComponentInstallDto componentInstallDto;
    private String scene;

    @JSONField(serialize=false)
    public Node getSshNode() {
        if (CollectionUtils.isEmpty(this.nodePools) || CollectionUtils.isEmpty(this.nodePools.get(0).getNodeDtoList())) {
            throw new EcontainerException(EcontainerError.PARAM_ERROR);
        }
        return this.nodePools.get(0).getNodeDtoList().get(0);
    }

    public void fill() {
        List<File> packageFiles = EcontainerFileUtils.getPackageFiles(this.path);
        this.version = this.getVersion(packageFiles, ConsistencyPattern.PATTERN_A3000_FUSIONCOMPUTE_K8S);
        this.managerControlSoftwareVersion = this.getVersion(packageFiles, ConsistencyPattern.PATTERN_A3000_FUSIONCUBE_METAVISION);
        this.osVersion = StringUtils.formatTxt((String)"EulerOS-%s", (Object[])new Object[]{this.getVersion(packageFiles, ConsistencyPattern.PATTERN_A3000_EULEROS_FILE)});
    }

    private String getVersion(List<File> packageFiles, Pattern pattern) {
        return packageFiles.stream().map(File::getName).map(pattern::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).findFirst().orElseThrow(() -> new EcontainerException(EcontainerError.PACKAGE_PATH_INVALID));
    }

    @Generated
    private static String $default$name() {
        return "auto-default-cluster";
    }

    @Generated
    private static boolean $default$masterSchedulable() {
        return true;
    }

    @Generated
    private static Quorum $default$quorum() {
        return Quorum.LOCAL;
    }

    @Generated
    private static String $default$scene() {
        return "all";
    }

    @Generated
    EcontainerDeployParamEntity(String path, String adminPwd, List<NodePool> nodePools, NicInfo manageNic, NicInfo businessNic, String name, String version, String managerControlSoftwareVersion, String managerControlInitpasswd, String managerControlTrapIp, String osVersion, boolean canAudit, boolean masterSchedulable, boolean multusEnable, int imageRepoSize, ContainerNetwork containerNetwork, Quorum quorum, List<String> dns, List<String> ntpIp, ComponentInstallDto componentInstallDto, String scene) {
        this.path = path;
        this.adminPwd = adminPwd;
        this.nodePools = nodePools;
        this.manageNic = manageNic;
        this.businessNic = businessNic;
        this.name = name;
        this.version = version;
        this.managerControlSoftwareVersion = managerControlSoftwareVersion;
        this.managerControlInitpasswd = managerControlInitpasswd;
        this.managerControlTrapIp = managerControlTrapIp;
        this.osVersion = osVersion;
        this.canAudit = canAudit;
        this.masterSchedulable = masterSchedulable;
        this.multusEnable = multusEnable;
        this.imageRepoSize = imageRepoSize;
        this.containerNetwork = containerNetwork;
        this.quorum = quorum;
        this.dns = dns;
        this.ntpIp = ntpIp;
        this.componentInstallDto = componentInstallDto;
        this.scene = scene;
    }

    @Generated
    public static EcontainerDeployParamEntityBuilder builder() {
        return new EcontainerDeployParamEntityBuilder();
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getAdminPwd() {
        return this.adminPwd;
    }

    @Generated
    public List<NodePool> getNodePools() {
        return this.nodePools;
    }

    @Generated
    public NicInfo getManageNic() {
        return this.manageNic;
    }

    @Generated
    public NicInfo getBusinessNic() {
        return this.businessNic;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getManagerControlSoftwareVersion() {
        return this.managerControlSoftwareVersion;
    }

    @Generated
    public String getManagerControlInitpasswd() {
        return this.managerControlInitpasswd;
    }

    @Generated
    public String getManagerControlTrapIp() {
        return this.managerControlTrapIp;
    }

    @Generated
    public String getOsVersion() {
        return this.osVersion;
    }

    @Generated
    public boolean isCanAudit() {
        return this.canAudit;
    }

    @Generated
    public boolean isMasterSchedulable() {
        return this.masterSchedulable;
    }

    @Generated
    public boolean isMultusEnable() {
        return this.multusEnable;
    }

    @Generated
    public int getImageRepoSize() {
        return this.imageRepoSize;
    }

    @Generated
    public ContainerNetwork getContainerNetwork() {
        return this.containerNetwork;
    }

    @Generated
    public Quorum getQuorum() {
        return this.quorum;
    }

    @Generated
    public List<String> getDns() {
        return this.dns;
    }

    @Generated
    public List<String> getNtpIp() {
        return this.ntpIp;
    }

    @Generated
    public ComponentInstallDto getComponentInstallDto() {
        return this.componentInstallDto;
    }

    @Generated
    public String getScene() {
        return this.scene;
    }

    @Generated
    public static class EcontainerDeployParamEntityBuilder {
        @Generated
        private String path;
        @Generated
        private String adminPwd;
        @Generated
        private List<NodePool> nodePools;
        @Generated
        private NicInfo manageNic;
        @Generated
        private NicInfo businessNic;
        @Generated
        private boolean name$set;
        @Generated
        private String name$value;
        @Generated
        private String version;
        @Generated
        private String managerControlSoftwareVersion;
        @Generated
        private String managerControlInitpasswd;
        @Generated
        private String managerControlTrapIp;
        @Generated
        private String osVersion;
        @Generated
        private boolean canAudit;
        @Generated
        private boolean masterSchedulable$set;
        @Generated
        private boolean masterSchedulable$value;
        @Generated
        private boolean multusEnable;
        @Generated
        private int imageRepoSize;
        @Generated
        private ContainerNetwork containerNetwork;
        @Generated
        private boolean quorum$set;
        @Generated
        private Quorum quorum$value;
        @Generated
        private List<String> dns;
        @Generated
        private List<String> ntpIp;
        @Generated
        private ComponentInstallDto componentInstallDto;
        @Generated
        private boolean scene$set;
        @Generated
        private String scene$value;

        @Generated
        EcontainerDeployParamEntityBuilder() {
        }

        @Generated
        public EcontainerDeployParamEntityBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder adminPwd(String adminPwd) {
            this.adminPwd = adminPwd;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder nodePools(List<NodePool> nodePools) {
            this.nodePools = nodePools;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder manageNic(NicInfo manageNic) {
            this.manageNic = manageNic;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder businessNic(NicInfo businessNic) {
            this.businessNic = businessNic;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder name(String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder managerControlSoftwareVersion(String managerControlSoftwareVersion) {
            this.managerControlSoftwareVersion = managerControlSoftwareVersion;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder managerControlInitpasswd(String managerControlInitpasswd) {
            this.managerControlInitpasswd = managerControlInitpasswd;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder managerControlTrapIp(String managerControlTrapIp) {
            this.managerControlTrapIp = managerControlTrapIp;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder canAudit(boolean canAudit) {
            this.canAudit = canAudit;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder masterSchedulable(boolean masterSchedulable) {
            this.masterSchedulable$value = masterSchedulable;
            this.masterSchedulable$set = true;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder multusEnable(boolean multusEnable) {
            this.multusEnable = multusEnable;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder imageRepoSize(int imageRepoSize) {
            this.imageRepoSize = imageRepoSize;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder containerNetwork(ContainerNetwork containerNetwork) {
            this.containerNetwork = containerNetwork;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder quorum(Quorum quorum) {
            this.quorum$value = quorum;
            this.quorum$set = true;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder dns(List<String> dns) {
            this.dns = dns;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder ntpIp(List<String> ntpIp) {
            this.ntpIp = ntpIp;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder componentInstallDto(ComponentInstallDto componentInstallDto) {
            this.componentInstallDto = componentInstallDto;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntityBuilder scene(String scene) {
            this.scene$value = scene;
            this.scene$set = true;
            return this;
        }

        @Generated
        public EcontainerDeployParamEntity build() {
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = EcontainerDeployParamEntity.$default$name();
            }
            boolean masterSchedulable$value = this.masterSchedulable$value;
            if (!this.masterSchedulable$set) {
                masterSchedulable$value = EcontainerDeployParamEntity.$default$masterSchedulable();
            }
            Quorum quorum$value = this.quorum$value;
            if (!this.quorum$set) {
                quorum$value = EcontainerDeployParamEntity.$default$quorum();
            }
            String scene$value = this.scene$value;
            if (!this.scene$set) {
                scene$value = EcontainerDeployParamEntity.$default$scene();
            }
            return new EcontainerDeployParamEntity(this.path, this.adminPwd, this.nodePools, this.manageNic, this.businessNic, name$value, this.version, this.managerControlSoftwareVersion, this.managerControlInitpasswd, this.managerControlTrapIp, this.osVersion, this.canAudit, masterSchedulable$value, this.multusEnable, this.imageRepoSize, this.containerNetwork, quorum$value, this.dns, this.ntpIp, this.componentInstallDto, scene$value);
        }

        @Generated
        public String toString() {
            return "EcontainerDeployParamEntity.EcontainerDeployParamEntityBuilder(path=" + this.path + ", adminPwd=" + this.adminPwd + ", nodePools=" + this.nodePools + ", manageNic=" + this.manageNic + ", businessNic=" + this.businessNic + ", name$value=" + this.name$value + ", version=" + this.version + ", managerControlSoftwareVersion=" + this.managerControlSoftwareVersion + ", managerControlInitpasswd=" + this.managerControlInitpasswd + ", managerControlTrapIp=" + this.managerControlTrapIp + ", osVersion=" + this.osVersion + ", canAudit=" + this.canAudit + ", masterSchedulable$value=" + this.masterSchedulable$value + ", multusEnable=" + this.multusEnable + ", imageRepoSize=" + this.imageRepoSize + ", containerNetwork=" + this.containerNetwork + ", quorum$value=" + this.quorum$value + ", dns=" + this.dns + ", ntpIp=" + this.ntpIp + ", componentInstallDto=" + this.componentInstallDto + ", scene$value=" + this.scene$value + ")";
        }
    }
}

