/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerFileUtils;
import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

public class EcontainerFile {
    private final File eContainerInstaller;
    private final File eContainerSoftware;
    private final File metaVision;
    private final File k8sSoftware;
    private final File csi;

    public EcontainerFile(String path) {
        List<File> packageFiles = EcontainerFileUtils.getPackageFiles(path);
        this.eContainerInstaller = this.getFile(packageFiles, ConsistencyPattern::isA3000EContainerInstallerPackage);
        this.eContainerSoftware = this.getFile(packageFiles, ConsistencyPattern::isA3000EContainerSoftwarePackage);
        this.metaVision = this.getFile(packageFiles, ConsistencyPattern::isA3000FusionCubeMetaVisionPackage);
        this.k8sSoftware = this.getFile(packageFiles, ConsistencyPattern::isA3000FusionComputeK8SPackage);
        this.csi = this.getFile(packageFiles, ConsistencyPattern::isA3000EsdkCsiPackage);
    }

    private File getFile(List<File> packageFiles, Predicate<String> pattern) {
        return packageFiles.stream().filter(file -> pattern.test(file.getName())).findFirst().orElseThrow(() -> new EcontainerException(EcontainerError.PACKAGE_PATH_INVALID));
    }

    @Generated
    public File getEContainerInstaller() {
        return this.eContainerInstaller;
    }

    @Generated
    public File getEContainerSoftware() {
        return this.eContainerSoftware;
    }

    @Generated
    public File getMetaVision() {
        return this.metaVision;
    }

    @Generated
    public File getK8sSoftware() {
        return this.k8sSoftware;
    }

    @Generated
    public File getCsi() {
        return this.csi;
    }
}

