/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity;

import com.huawei.smartkit.drop.util.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class IpConfig {
    private String targetIp;
    private String mask;
    private String gateway;

    public Map<String, Object> getBmcIpParam(String vendor) {
        if (IpUtils.isValidIpV4((String)this.targetIp)) {
            return this.buildIpv4Param(vendor);
        }
        if (IpUtils.isValidIpV6((String)this.targetIp)) {
            return this.buildIpv6Param(vendor);
        }
        throw new EcontainerException(EcontainerError.INVALID_IP);
    }

    private Map<String, Object> buildIpv6Param(String vendor) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> ipParam = new HashMap<String, Object>();
        ipParam.put("AddressOrigin", "Static");
        ipParam.put("Address", this.targetIp);
        ipParam.put("PrefixLength", Integer.parseInt(this.mask));
        param.put("IPv6Addresses", Collections.singletonList(ipParam));
        param.put("IPv6DefaultGateway", this.gateway);
        IpConfig.buildOemParam(vendor, param);
        return param;
    }

    private Map<String, Object> buildIpv4Param(String vendor) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> ipParam = new HashMap<String, String>();
        ipParam.put("AddressOrigin", "Static");
        ipParam.put("Address", this.targetIp);
        ipParam.put("SubnetMask", this.mask);
        param.put("IPv4Addresses", Collections.singletonList(ipParam));
        IpConfig.buildOemParam(vendor, param);
        return param;
    }

    private static void buildOemParam(String vendor, Map<String, Object> param) {
        HashMap oem = new HashMap(1);
        HashMap<String, String> venderMap = new HashMap<String, String>(1);
        venderMap.put("IPVersion", "IPv4AndIPv6");
        oem.put(vendor, venderMap);
        param.put("Oem", oem);
    }

    @Generated
    IpConfig(String targetIp, String mask, String gateway) {
        this.targetIp = targetIp;
        this.mask = mask;
        this.gateway = gateway;
    }

    @Generated
    public static IpConfigBuilder builder() {
        return new IpConfigBuilder();
    }

    @Generated
    public String getTargetIp() {
        return this.targetIp;
    }

    @Generated
    public String getMask() {
        return this.mask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public static class IpConfigBuilder {
        @Generated
        private String targetIp;
        @Generated
        private String mask;
        @Generated
        private String gateway;

        @Generated
        IpConfigBuilder() {
        }

        @Generated
        public IpConfigBuilder targetIp(String targetIp) {
            this.targetIp = targetIp;
            return this;
        }

        @Generated
        public IpConfigBuilder mask(String mask) {
            this.mask = mask;
            return this;
        }

        @Generated
        public IpConfigBuilder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Generated
        public IpConfig build() {
            return new IpConfig(this.targetIp, this.mask, this.gateway);
        }

        @Generated
        public String toString() {
            return "IpConfig.IpConfigBuilder(targetIp=" + this.targetIp + ", mask=" + this.mask + ", gateway=" + this.gateway + ")";
        }
    }
}

