/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.http;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.http.BmcHttpRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.http.IbmcRestExecutor;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.http.LoggerInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import okhttp3.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class BmcHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmcHttpClient.class);
    private String sessionId;
    private Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final BmcHttpRequest requestApi;

    public BmcHttpClient(String ip) {
        this.requestApi = (BmcHttpRequest)HttpRequestApiFactory.createRequestApi((String)("https://" + ip), BmcHttpRequest.class, (Interceptor[])new Interceptor[]{new LoggerInterceptor()});
    }

    public boolean login(String username, String password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UserName", username);
        params.put("Password", password);
        try {
            Response response = this.requestApi.loginBmc(this.buildDefaultHeaders(), params).execute();
            if (!response.isSuccessful()) {
                log.error("login ibmc failed.");
                return false;
            }
            String token = response.headers().get("X-Auth-Token");
            this.sessionId = Optional.ofNullable(response.body()).map(maps -> maps.get("Id")).map(String::valueOf).orElse("");
            this.defaultHeaders = this.buildDefaultHeaders();
            this.defaultHeaders.put("X-Auth-Token", token);
            return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{token, this.sessionId});
        }
        catch (IOException e) {
            log.error("login ibmc failed.", (Throwable)e);
            return false;
        }
    }

    public Response<Map<String, Object>> execute(IbmcRestExecutor executor) throws IOException {
        return executor.execute(this.defaultHeaders, this.requestApi).execute();
    }

    public boolean logout() {
        if (StringUtils.isEmpty((CharSequence)this.sessionId)) {
            log.warn("not find session id, not need to logout.");
            return true;
        }
        try {
            return this.requestApi.releaseConnection(this.defaultHeaders, this.sessionId).execute().isSuccessful();
        }
        catch (IOException e) {
            log.error("logout ibmc failed.", (Throwable)e);
            return false;
        }
    }

    private Map<String, String> buildDefaultHeaders() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Connection", "keep-alive");
        header.put("Accept-Encoding", "gzip, deflate, br");
        header.put("Accept", "*/*");
        return header;
    }
}

