/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssdp.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.BmcNode;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ContainerConfigParam;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.IpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.User;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssdp.BmcConfigService;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.bmc.ConfigBmcIpTask;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.bmc.NodeConfigResult;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.bmc.NodeConfigTask;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.ssdp.SnMappingIpTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BmcConfigServiceImpl
implements BmcConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmcConfigServiceImpl.class);

    @Override
    public String configBmcIp(String taskId, List<ContainerConfigParam> configParams) {
        log.info("prepare to config bmc ip, taskId : {}.", (Object)taskId);
        this.validParam(configParams);
        List<BmcNode> bmcNodes = this.mapToBmcNodes(configParams);
        log.info("start to config bmc node : {}.", (Object)bmcNodes.stream().map(BmcNode::getDeviceName).collect(Collectors.joining(",")));
        ConfigBmcIpTask bmcIpTask = this.buildTask(taskId, bmcNodes);
        log.info("start config bmc ip task finish, id : {}.", (Object)bmcIpTask.getTaskId());
        return bmcIpTask.getTaskId();
    }

    private List<BmcNode> mapToBmcNodes(List<ContainerConfigParam> configParams) {
        return configParams.stream().map(this::buildBmcNode).collect(Collectors.toList());
    }

    private BmcNode buildBmcNode(ContainerConfigParam param) {
        return BmcNode.builder().bmcIpConfig(this.buildIpConfig(param)).currentIp(param.getBmcInfo().getCurrentIp()).sn(StringUtils.isEmpty((CharSequence)param.getSn()) ? param.getSn() : param.getSn().trim()).user(new User(param.getBmcInfo().getUsername(), param.getBmcInfo().getOrgPwd(), param.getBmcInfo().getNewPwd())).configType(param.getBmcInfo().getConfigType()).build();
    }

    private IpConfig buildIpConfig(ContainerConfigParam param) {
        return IpConfig.builder().targetIp(param.getBmcInfo().getTargetIp()).gateway(param.getGateway()).mask(param.getMask()).build();
    }

    @NotNull
    private synchronized ConfigBmcIpTask buildTask(String taskId, List<BmcNode> bmcNodes) {
        this.checkDeviceRunning(taskId, bmcNodes);
        if (bmcNodes.stream().anyMatch(node -> "sn".equals(node.getConfigType()))) {
            this.startSsdpSearch();
        }
        ConfigBmcIpTask bmcIpTask = this.getConfigTask(taskId, bmcNodes);
        CommonTaskManager.getInstance().addTask((BaseTask)bmcIpTask);
        CommonTaskManager.getInstance().startTaskById(bmcIpTask.getTaskId());
        return bmcIpTask;
    }

    private ConfigBmcIpTask getConfigTask(String taskId, List<BmcNode> bmcNodes) {
        return CommonTaskManager.getInstance().queryTaskById(taskId).map(task -> this.handleWithExistsTask(taskId, bmcNodes, (BaseTask)task)).orElseGet(() -> this.buildConfigTask(taskId, bmcNodes));
    }

    private ConfigBmcIpTask buildConfigTask(String taskId, List<BmcNode> bmcNodes) {
        return ((ConfigBmcIpTask.ConfigBmcIpTaskBuilder)((ConfigBmcIpTask.ConfigBmcIpTaskBuilder)((ConfigBmcIpTask.ConfigBmcIpTaskBuilder)((ConfigBmcIpTask.ConfigBmcIpTaskBuilder)ConfigBmcIpTask.builder().taskId(taskId)).isExecuteSubTasks(false)).taskResult(new NodeConfigResult())).subTasks(BmcConfigServiceImpl.buildConfigSubTask(bmcNodes))).build();
    }

    @NotNull
    private ConfigBmcIpTask handleWithExistsTask(String taskId, List<BmcNode> bmcNodes, BaseTask baseTask) {
        ConfigBmcIpTask configBmcIpTask = (ConfigBmcIpTask)baseTask;
        Map<String, NodeConfigTask> ipTaskMap = configBmcIpTask.getSubTasks().stream().map(NodeConfigTask.class::cast).collect(BmcConfigServiceImpl.collectorToMap());
        for (BmcNode bmcNode : bmcNodes) {
            String targetIp = bmcNode.getBmcIpConfig().getTargetIp();
            if (ipTaskMap.containsKey(targetIp)) {
                NodeConfigTask nodeConfigTask = ipTaskMap.get(targetIp);
                nodeConfigTask.setBmcNode(bmcNode);
                nodeConfigTask.setTaskResult(new NodeConfigResult());
                continue;
            }
            configBmcIpTask.getSubTasks().add(((NodeConfigTask.NodeConfigTaskBuilder)((Object)((NodeConfigTask.NodeConfigTaskBuilder)NodeConfigTask.builder().taskResult(new NodeConfigResult())).bmcNode(bmcNode))).build());
        }
        configBmcIpTask.setTaskResult(new NodeConfigResult());
        return configBmcIpTask;
    }

    @NotNull
    private static Collector<NodeConfigTask, ?, Map<String, NodeConfigTask>> collectorToMap() {
        return Collectors.toMap(task -> task.getBmcNode().getBmcIpConfig().getTargetIp(), Function.identity(), (node, repeatNode) -> {
            throw new EcontainerException(EcontainerError.TARGET_IP_REPEAT);
        });
    }

    private void checkDeviceRunning(String taskId, List<BmcNode> bmcNodes) {
        CommonTaskManager.getInstance().queryTaskById(taskId).filter(this::taskRunning).ifPresent(task -> {
            throw new EcontainerException(EcontainerError.TASK_RUNNING);
        });
        Set sn = bmcNodes.stream().map(BmcNode::getSn).collect(Collectors.toSet());
        List configBmcIpTasks = CommonTaskManager.getInstance().queryTaskByType(ConfigBmcIpTask.class);
        configBmcIpTasks.stream().flatMap(task -> task.getSubTasks().stream()).filter(NodeConfigTask.class::isInstance).map(NodeConfigTask.class::cast).filter(this::taskRunning).filter(task -> sn.contains(task.getBmcNode().getSn())).findAny().ifPresent(task -> {
            throw new EcontainerException(EcontainerError.DEVICE_RUNNING, Arrays.asList((Object)task.getBmcNode().getSn()));
        });
    }

    private boolean taskRunning(BaseTask task) {
        return TaskStatus.RUNNING.equals((Object)task.getTaskResult().getTaskStatus());
    }

    private void startSsdpSearch() {
        SnMappingIpTask.INS.startSearch();
        ThreadUtils.submit(SnMappingIpTask.INS::mapping);
    }

    @NotNull
    private static List<BaseTask> buildConfigSubTask(List<BmcNode> bmcNodes) {
        return bmcNodes.stream().map(node -> ((NodeConfigTask.NodeConfigTaskBuilder)NodeConfigTask.builder().bmcNode((BmcNode)node).taskResult((BaseTaskResult)new NodeConfigResult())).build()).collect(Collectors.toList());
    }

    @Override
    public Map<String, BaseTaskResult> queryConfigIpResult(String taskId) {
        return ((BaseTask)CommonTaskManager.getInstance().queryTaskById(taskId).orElseThrow(() -> new EcontainerException(EcontainerError.NO_TASK_FOUND))).getSubTasks().stream().map(NodeConfigTask.class::cast).collect(Collectors.toMap(task -> task.getBmcNode().getBmcIpConfig().getTargetIp(), BaseTask::getTaskResult));
    }

    private void validParam(List<ContainerConfigParam> bmcNodes) {
        if (CollectionUtils.isEmpty(bmcNodes)) {
            throw new EcontainerException(EcontainerError.DEVICE_NOT_FOUND);
        }
        List<Object> emptySnNodes = bmcNodes.stream().filter(node -> "sn".equals(node.getBmcInfo().getConfigType())).filter(node -> StringUtils.isEmpty((CharSequence)node.getSn())).map(node -> node.getBmcInfo().getTargetIp()).collect(Collectors.toList());
        if (!emptySnNodes.isEmpty()) {
            throw new EcontainerException(EcontainerError.NODE_SN_REQUIRE, emptySnNodes);
        }
    }

    @Generated
    public BmcConfigServiceImpl() {
    }
}

