/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSessionKeepContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshSessionKeepContext.class);
    private SshShellService sshShellService;
    private SshSftpService sshSftpService;
    private final Set<ClientSession> clientSessions = new HashSet<ClientSession>();

    public static SshSessionKeepContext getInstance() {
        return SshSessionKeepContextHolder.INSTANCE;
    }

    public SshSftpService getSshSftpService(SshCmd cmd) throws SshException {
        if (Objects.nonNull(this.sshSftpService) && this.sshSftpService.isConnected()) {
            return this.sshSftpService;
        }
        this.sshSftpService = SshManager.createSshSftpService((ClientSession)this.getSshSession(cmd));
        this.sshSftpService.connect();
        log.info("create sftp service : {}.", (Object)this.sshSftpService);
        return this.sshSftpService;
    }

    public SshShellService getSshClientOfRoot(SshCmd cmd) throws SshException {
        if (Objects.nonNull(this.sshShellService) && this.sshShellService.isConnected()) {
            return this.sshShellService;
        }
        this.sshShellService = SshManager.createSshShellService((ClientSession)this.getSshSession(cmd));
        this.sshShellService.connect(Integer.MAX_VALUE);
        this.sshShellService.changeRootPermission(cmd.getRootPassword());
        String aliveSession = this.sshShellService.execCommand("TMOUT=0");
        log.info("aliveSession result :{}", (Object)aliveSession);
        return this.sshShellService;
    }

    public void releaseSshAndSftpService() {
        log.info("start release ssh service : {}.", (Object)this.sshShellService);
        if (Objects.nonNull(this.sshShellService) && this.sshShellService.isConnected()) {
            log.info("disconnect ssh service.");
            this.sshShellService.disconnect();
        }
        this.sshShellService = null;
        log.info("start release sftp service : {}.", (Object)this.sshSftpService);
        if (Objects.nonNull(this.sshSftpService) && this.sshSftpService.isConnected()) {
            this.sshSftpService.disconnect();
            log.info("disconnect sftp service.");
        }
        this.sshSftpService = null;
        log.info("start to release client session, size : {}.", (Object)this.clientSessions.size());
        this.clientSessions.forEach(SshManager::releaseSession);
        this.clientSessions.clear();
    }

    private ClientSession getSshSession(SshCmd cmd) throws SshException {
        ClientSession clientSession = SshManager.getSession((SshConnInfo)this.getConnInfo(cmd));
        this.clientSessions.add(clientSession);
        return clientSession;
    }

    private SshConnInfo getConnInfo(SshCmd cmd) {
        return SshConnInfo.builder().hostName(cmd.getIp()).userName(cmd.getUserName()).userPwd(cmd.getPassword()).build();
    }

    private static class SshSessionKeepContextHolder {
        static final SshSessionKeepContext INSTANCE = new SshSessionKeepContext();

        private SshSessionKeepContextHolder() {
        }
    }
}

