/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.bmc;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.constance.BmcConstants;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.BmcNode;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.http.BmcHttpRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.ssdp.SnMappingIpTask;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.UrlUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodeConfigTask.class);
    private BmcNode bmcNode;
    private BmcHttpRequest requestApi;
    private String authToken;
    private Map<String, String> defaultHeader;
    private String sessionId;
    private String bmcVendor;

    public void beforeExecute() {
        this.waitSsdpResult();
        this.defaultHeader = this.getPreLoginBmcRequestHeader();
        this.initSession();
        this.bmcVendor = this.initBmcVendor();
    }

    private void waitSsdpResult() {
        if (!"sn".equals(this.bmcNode.getConfigType())) {
            return;
        }
        while (SnMappingIpTask.INS.isSearching()) {
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            if (!SnMappingIpTask.INS.hadSearchIp(this.bmcNode.getSn())) continue;
            this.bmcNode.setCurrentIp(SnMappingIpTask.INS.getSearchedIp(this.bmcNode.getSn()));
            return;
        }
        if (SnMappingIpTask.INS.hadSearchIp(this.bmcNode.getSn())) {
            this.bmcNode.setCurrentIp(SnMappingIpTask.INS.getSearchedIp(this.bmcNode.getSn()));
            return;
        }
        throw new EcontainerException(EcontainerError.LOCAL_LINK_ERROR);
    }

    public void execute() throws TaskException {
        try {
            this.configBmcIp();
            this.changePassword();
        }
        catch (IOException e) {
            log.error("config bmc ip error", (Throwable)e);
            throw new EcontainerException(EcontainerError.BMC_REQUEST_ERROR);
        }
    }

    private void changePassword() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.bmcNode.getUser().getNewPassword()) || this.bmcNode.getUser().getNewPassword().equals(this.bmcNode.getUser().getPassword())) {
            return;
        }
        this.appendTaskDetail("start to change bmc password");
        this.modifyPassword(this.bmcNode);
    }

    private void modifyPassword(BmcNode bmcNode) throws IOException {
        retrofit2.Response response = this.requestApi.queryUsers(this.defaultHeader).execute();
        if (!response.isSuccessful() || Objects.isNull(response.body())) {
            throw new EcontainerException(EcontainerError.MODIFY_PASSWORD_FAILED);
        }
        Object members = ((Map)response.body()).get("Members");
        if (Objects.isNull(members)) {
            throw new EcontainerException(EcontainerError.MODIFY_PASSWORD_FAILED);
        }
        String userId = JSON.parseArray((String)JSON.toJSONString(members)).stream().map(member -> JSON.parseObject((String)JSON.toJSONString((Object)member))).filter(member -> bmcNode.getUser().getUsername().equals(member.getString("UserName"))).map(member -> member.getString("Id")).findAny().orElseThrow(() -> new EcontainerException(EcontainerError.MODIFY_PASSWORD_FAILED));
        retrofit2.Response queryResponse = this.requestApi.queryUserInfo(this.defaultHeader, userId).execute();
        this.handleResponse((retrofit2.Response<Map<String, Object>>)queryResponse);
        String eTag = queryResponse.headers().get("ETag");
        this.defaultHeader.put("If-Match", eTag);
        retrofit2.Response modifyResponse = this.requestApi.modifyUserInfo(this.defaultHeader, userId, this.buildLoginParam(bmcNode.getUser().getUsername(), bmcNode.getUser().getNewPassword())).execute();
        this.handleResponse((retrofit2.Response<Map<String, Object>>)modifyResponse);
    }

    private void setBmcIp(String managerId, String ethResource) throws IOException {
        retrofit2.Response response = this.requestApi.setBmcIp(this.defaultHeader, this.buildConfigParam(), managerId, ethResource).execute();
        log.info("set bmc ip response :{}", (Object)response);
        this.handleResponse((retrofit2.Response<Map<String, Object>>)response);
    }

    private Map<String, Object> buildConfigParam() {
        Map<String, Object> bmcIpParam = this.bmcNode.getBmcIpConfig().getBmcIpParam(this.bmcVendor);
        bmcIpParam.put("HostName", this.bmcNode.getDeviceName());
        log.info("config bmc ip param :{}", bmcIpParam);
        return bmcIpParam;
    }

    private void setConfigHeader(String managerId, String ethResource) throws IOException {
        retrofit2.Response response = this.requestApi.getBmcIp(this.defaultHeader, managerId, ethResource).execute();
        this.handleResponse((retrofit2.Response<Map<String, Object>>)response);
        this.defaultHeader.put("If-Match", response.headers().get("ETag"));
    }

    private void configBmcIp() throws IOException {
        String managerId = this.queryManagerId();
        String ethResource = this.getEthResource(managerId);
        this.setConfigHeader(managerId, ethResource);
        this.setBmcIp(managerId, ethResource);
    }

    private String getEthResource(String managerId) throws IOException {
        retrofit2.Response response = this.requestApi.getEthernetUri(this.defaultHeader, managerId).execute();
        this.handleResponse((retrofit2.Response<Map<String, Object>>)response);
        String ethUri = this.getFirstMemberResource((retrofit2.Response<Map<String, Object>>)response);
        return ethUri.substring(ethUri.lastIndexOf("/") + 1);
    }

    private String getFirstMemberResource(retrofit2.Response<Map<String, Object>> response) {
        Object member = ((Map)response.body()).get("Members");
        JSONArray ethMember = JSON.parseArray((String)JSON.toJSONString(member));
        if (ethMember.isEmpty()) {
            throw new EcontainerException(EcontainerError.BMC_REQUEST_ERROR);
        }
        return ethMember.getJSONObject(0).getString("@odata.id");
    }

    private void handleResponse(retrofit2.Response<Map<String, Object>> response) {
        log.error("response:{}", response.body());
        this.appendTaskDetail(this.getStringBody((Map)response.body()));
        if (!response.isSuccessful()) {
            throw new EcontainerException(EcontainerError.BMC_REQUEST_ERROR);
        }
    }

    private String queryManagerId() throws IOException {
        retrofit2.Response response = this.requestApi.getManagerMembers(this.defaultHeader).execute();
        this.handleResponse((retrofit2.Response<Map<String, Object>>)response);
        String managerIdUri = this.getFirstMemberResource((retrofit2.Response<Map<String, Object>>)response);
        return managerIdUri.substring(managerIdUri.lastIndexOf("/") + 1);
    }

    private BmcHttpRequest buildRequestApi() {
        return (BmcHttpRequest)HttpRequestApiFactory.createRequestApi((String)UrlUtils.getHttpBaseUrlByIp((String)this.bmcNode.getCurrentIp()), BmcHttpRequest.class, (Interceptor[])new Interceptor[]{new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                String url = request.url().toString();
                log.info("{} url:{}", (Object)request.method(), (Object)url);
                Response response = chain.proceed(request);
                log.info("response :{}", (Object)response.message());
                return response;
            }
        }});
    }

    @NotNull
    private Map<String, String> buildLoginParam(String username, String password) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("UserName", username);
        param.put("Password", password);
        return param;
    }

    private boolean loginBmc() {
        retrofit2.Response<Map<String, Object>> response;
        Map<String, String> param = this.buildLoginParam(this.bmcNode.getUser().getUsername(), this.bmcNode.getUser().getPassword());
        Map<String, String> headers = this.getPreLoginBmcRequestHeader();
        try {
            response = this.requestApi.loginBmc(headers, param).execute();
            response = this.handleFirstLogin(response, param, headers);
        }
        catch (IOException e) {
            log.error("login bmc failed", (Throwable)e);
            return false;
        }
        if (!response.isSuccessful()) {
            log.error("try use new pwd");
            response = this.tryWithNewPwd(headers, response);
        }
        if (!response.isSuccessful()) {
            log.error("login bmc failed,current code {}", (Object)response.code());
            return false;
        }
        this.authToken = response.headers().get("X-Auth-Token");
        this.sessionId = String.valueOf(((Map)response.body()).get("Id"));
        return StringUtils.isNotEmpty((CharSequence)this.authToken);
    }

    private retrofit2.Response<Map<String, Object>> tryWithNewPwd(Map<String, String> headers, retrofit2.Response<Map<String, Object>> response) {
        if (StringUtils.isEmpty((CharSequence)this.bmcNode.getUser().getNewPassword())) {
            log.info("new pwd is empty");
            return response;
        }
        try {
            retrofit2.Response newResponse = this.requestApi.loginBmc(headers, this.buildLoginParam(this.bmcNode.getUser().getUsername(), this.bmcNode.getUser().getNewPassword())).execute();
            if (newResponse.isSuccessful()) {
                this.bmcNode.getUser().setNewPwdToPwd();
            }
            return newResponse;
        }
        catch (IOException e) {
            log.error("login bmc try new pwd failed", (Throwable)e);
            return response;
        }
    }

    @NotNull
    private retrofit2.Response<Map<String, Object>> handleFirstLogin(retrofit2.Response<Map<String, Object>> response, Map<String, String> param, Map<String, String> headers) throws IOException {
        if (!this.firstLogin(response)) {
            return response;
        }
        if (this.hasNoNewPassword()) {
            throw new EcontainerException(EcontainerError.REQUIRE_NEW_PWD);
        }
        log.info("start modify default password");
        this.modifyDefaultPassword(this.bmcNode);
        param.put("Password", this.bmcNode.getUser().getPassword());
        return this.requestApi.loginBmc(headers, param).execute();
    }

    private boolean hasNoNewPassword() {
        return StringUtils.isEmpty((CharSequence)this.bmcNode.getUser().getNewPassword());
    }

    private boolean firstLogin(retrofit2.Response<Map<String, Object>> response) {
        if (Objects.isNull(response.body())) {
            return false;
        }
        return ((Map)response.body()).toString().contains(BmcConstants.DEFAULT_PASSWORD_TIPS);
    }

    private void modifyDefaultPassword(BmcNode bmcNode) throws IOException {
        Map<String, String> headers = this.getPreLoginBmcRequestHeader();
        retrofit2.Response response = this.requestApi.modifyUserInfo(headers, "2", this.buildLoginParam(bmcNode.getUser().getUsername(), bmcNode.getUser().getNewPassword())).execute();
        headers.put("if-Match", response.headers().get("ETag"));
        response = this.requestApi.modifyUserInfo(headers, "2", this.buildLoginParam(bmcNode.getUser().getUsername(), bmcNode.getUser().getNewPassword())).execute();
        if (!response.isSuccessful()) {
            this.appendTaskDetail(this.getStringBody((Map)response.body()));
            throw new EcontainerException(EcontainerError.CONFIG_DEFAULT_PASSWORD_ERROR);
        }
        bmcNode.getUser().setNewPwdToPwd();
    }

    private String initBmcVendor() {
        try {
            retrofit2.Response response = this.requestApi.getBmcVendor().execute();
            this.handleResponse((retrofit2.Response<Map<String, Object>>)response);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(((Map)response.body()).get("Oem")));
            return jsonObject.keySet().stream().findFirst().orElse("Huawei");
        }
        catch (IOException e) {
            log.error("init bmc vendor error", (Throwable)e);
            throw new EcontainerException(EcontainerError.BMC_REQUEST_ERROR);
        }
    }

    private String getStringBody(Map<String, Object> body) {
        return MapUtils.isEmpty(body) ? "" : body.toString();
    }

    private void initSession() {
        this.requestApi = this.buildRequestApi();
        if (!this.loginBmc()) {
            throw new EcontainerException(EcontainerError.BMC_REQUEST_ERROR);
        }
        this.defaultHeader.put("X-Auth-Token", this.authToken);
    }

    private Map<String, String> getPreLoginBmcRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Connection", "keep-alive");
        header.put("Accept-Encoding", "gzip, deflate, br");
        header.put("Accept", "*/*");
        return header;
    }

    public void afterExecute() {
        try {
            this.requestApi.releaseConnection(this.defaultHeader, this.sessionId).execute();
        }
        catch (IOException e) {
            log.warn("release connection for :{} error", (Object)this.bmcNode.getSn(), (Object)e);
        }
    }

    @Generated
    protected NodeConfigTask(NodeConfigTaskBuilder<?, ?> b) {
        super(b);
        this.bmcNode = ((NodeConfigTaskBuilder)b).bmcNode;
        this.requestApi = ((NodeConfigTaskBuilder)b).requestApi;
        this.authToken = ((NodeConfigTaskBuilder)b).authToken;
        this.defaultHeader = ((NodeConfigTaskBuilder)b).defaultHeader;
        this.sessionId = ((NodeConfigTaskBuilder)b).sessionId;
        this.bmcVendor = ((NodeConfigTaskBuilder)b).bmcVendor;
    }

    @Generated
    public static NodeConfigTaskBuilder<?, ?> builder() {
        return new NodeConfigTaskBuilderImpl();
    }

    @Generated
    public BmcNode getBmcNode() {
        return this.bmcNode;
    }

    @Generated
    public void setBmcNode(BmcNode bmcNode) {
        this.bmcNode = bmcNode;
    }

    @Generated
    private static final class NodeConfigTaskBuilderImpl
    extends NodeConfigTaskBuilder<NodeConfigTask, NodeConfigTaskBuilderImpl> {
        @Generated
        private NodeConfigTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected NodeConfigTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public NodeConfigTask build() {
            return new NodeConfigTask(this);
        }
    }

    @Generated
    public static abstract class NodeConfigTaskBuilder<C extends NodeConfigTask, B extends NodeConfigTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private BmcNode bmcNode;
        @Generated
        private BmcHttpRequest requestApi;
        @Generated
        private String authToken;
        @Generated
        private Map<String, String> defaultHeader;
        @Generated
        private String sessionId;
        @Generated
        private String bmcVendor;

        @Generated
        public B bmcNode(BmcNode bmcNode) {
            this.bmcNode = bmcNode;
            return (B)this.self();
        }

        @Generated
        public B requestApi(BmcHttpRequest requestApi) {
            this.requestApi = requestApi;
            return (B)this.self();
        }

        @Generated
        public B authToken(String authToken) {
            this.authToken = authToken;
            return (B)this.self();
        }

        @Generated
        public B defaultHeader(Map<String, String> defaultHeader) {
            this.defaultHeader = defaultHeader;
            return (B)this.self();
        }

        @Generated
        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        @Generated
        public B bmcVendor(String bmcVendor) {
            this.bmcVendor = bmcVendor;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "NodeConfigTask.NodeConfigTaskBuilder(super=" + super.toString() + ", bmcNode=" + this.bmcNode + ", requestApi=" + this.requestApi + ", authToken=" + this.authToken + ", defaultHeader=" + this.defaultHeader + ", sessionId=" + this.sessionId + ", bmcVendor=" + this.bmcVendor + ")";
        }
    }
}

