/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.ssdp;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.ssdp.SsdpSearch;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnMappingIpTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnMappingIpTask.class);
    public static final SnMappingIpTask INS = new SnMappingIpTask();
    private volatile boolean searching = false;
    private final Map<String, String> sn2ip = new HashMap<String, String>();

    public synchronized void mapping() {
        this.searching = true;
        this.sn2ip.clear();
        this.getValidLockLinkIps().stream().map(inetAddress -> new SsdpSearch((InetAddress)inetAddress).search()).map(this::parseSsdpResponse).forEach(this.sn2ip::putAll);
        log.info("ssdp searched: {}", this.sn2ip);
        this.searching = false;
    }

    public boolean hadSearchIp(String sn) {
        return this.sn2ip.containsKey(sn);
    }

    public String getSearchedIp(String sn) {
        return this.sn2ip.get(sn);
    }

    private Set<InetAddress> getValidLockLinkIps() {
        HashSet<InetAddress> localAddress = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                localAddress.addAll(this.parseLocalIp(interfaces));
            }
        }
        catch (SocketException e) {
            log.error("Connection error.", (Throwable)e);
        }
        return localAddress;
    }

    private Set<InetAddress> parseLocalIp(Enumeration<NetworkInterface> interfaces) {
        HashSet<InetAddress> localAddress = new HashSet<InetAddress>();
        Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
        while (addresses.hasMoreElements()) {
            String addrString;
            InetAddress addr = addresses.nextElement();
            if (!this.isValidAddress(addr, addrString = addr.getHostAddress())) continue;
            localAddress.add(addr);
        }
        return localAddress;
    }

    private boolean isValidAddress(InetAddress addr, String addrString) {
        return addr instanceof Inet6Address && addrString.startsWith("fe80");
    }

    private Map<String, String> parseSsdpResponse(List<String> responses) {
        LinkedHashMap<String, String> sn2ipMap = new LinkedHashMap<String, String>();
        responses.stream().map(response -> response.split("\n")).forEach(lines -> this.parIpToSn((String[])lines, (Map<String, String>)sn2ipMap));
        return sn2ipMap;
    }

    private void parIpToSn(String[] lines, Map<String, String> sn2ipMap) {
        String sn = Arrays.stream(lines).filter(this::isSnDataLine).map(this::getSnFromSnDataLine).findFirst().orElse("");
        String ip = Arrays.stream(lines).filter(this::isIpDataLine).map(this::getIpFromIpDataLine).findFirst().orElse("");
        if (!sn.isEmpty()) {
            sn2ipMap.put(sn, ip);
        }
    }

    private boolean isSnDataLine(String line) {
        return line.startsWith("SERVER") && line.contains("SN/");
    }

    private boolean isIpDataLine(String line) {
        return line.startsWith("AL") && line.contains("redfish");
    }

    private String getSnFromSnDataLine(String line) {
        String[] strSplit = line.split("\\s+");
        return strSplit[strSplit.length - 1].replaceAll("SN/", "");
    }

    private String getIpFromIpDataLine(String line) {
        return line.split("/")[2];
    }

    public synchronized void startSearch() {
        if (this.searching) {
            throw new EcontainerException(EcontainerError.SSDP_RUNNING);
        }
        this.searching = true;
    }

    public void finishSearch() {
        this.searching = false;
    }

    @Generated
    private SnMappingIpTask() {
    }

    @Generated
    public boolean isSearching() {
        return this.searching;
    }

    @Generated
    public Map<String, String> getSn2ip() {
        return this.sn2ip;
    }
}

