/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.ssdp;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerConfigUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsdpSearch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsdpSearch.class);
    private static final String HTTP_HEAD = "M-SEARCH * HTTP/1.1";
    private static final String HTTP_HEAD_DEST_PORT = "HOST: [FF05::C]:1900";
    private static final String HTTP_HEAD_SSDP = "MAN: \"ssdp:discover\"";
    private static final String HTTP_HEAD_MX = "MX: " + EcontainerConfigUtil.getInteger("ssdp.response.timeout", 10);
    private static final String HTTP_HEAD_ST = "ST: ssdp:all";
    private static final int LOCAL_PORT = 64941;
    private static final int DEST_PORT = 1900;
    private static final int RECEIVE_TIME_OUT = EcontainerConfigUtil.getInteger("ssdp.response.timeout", 5000);
    private final InetAddress address;

    public List<String> search() {
        InetAddress inetaddress;
        String request = this.makeRequest();
        ArrayList<String> responses = new ArrayList<String>();
        byte[] requestByte = request.getBytes(Charset.defaultCharset());
        try {
            inetaddress = InetAddress.getByName("FF05::C");
        }
        catch (UnknownHostException e) {
            log.error("Ssdp socket error.", (Throwable)e);
            return responses;
        }
        DatagramPacket sendPacket = new DatagramPacket(requestByte, request.length(), inetaddress, 1900);
        try (DatagramSocket socket = new DatagramSocket(64941, this.address);){
            socket.send(sendPacket);
            String response = this.receiveResponseData(socket);
            responses.add(response);
        }
        catch (IOException e) {
            log.error("Ssdp socket error for local ip.:{}", (Object)this.address.getHostAddress());
        }
        return responses;
    }

    private String makeRequest() {
        ArrayList<String> requestList = new ArrayList<String>();
        requestList.add(HTTP_HEAD);
        requestList.add(HTTP_HEAD_DEST_PORT);
        requestList.add(HTTP_HEAD_SSDP);
        requestList.add(HTTP_HEAD_MX);
        requestList.add(HTTP_HEAD_ST);
        return String.join((CharSequence)System.lineSeparator(), requestList) + System.lineSeparator();
    }

    private String receiveResponseData(DatagramSocket socket) throws IOException {
        DatagramPacket receivePacket = new DatagramPacket(new byte[1024], 1024);
        socket.setSoTimeout(RECEIVE_TIME_OUT);
        socket.receive(receivePacket);
        return new String(receivePacket.getData(), Charset.defaultCharset());
    }

    @Generated
    public SsdpSearch(InetAddress address) {
        this.address = address;
    }
}

