/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask;

import com.alibaba.fastjson2.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerDetailResult;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerSubTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerTaskLevelResult;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.SshDeployEcontainerCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask.EcontainerStepTask;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask.QueryEcontainerDeploymentCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerConfigUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEcontainerDeployTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryEcontainerDeployTask.class);
    public static final String NAME = "query.eContainer.deploy.task";
    private static final int MAX_SSH_QUERY_FAILED_CNT = 15;
    private int querySshFailedCnt;
    private final QueryEcontainerDeploymentCmd cmd;
    private EcontainerDetailResult detailResult;

    public void execute() throws TaskException {
        this.querySshFailedCnt = 0;
        RetryUtils.retry(this::getResult, this::analysisResult, (int)EcontainerConfigUtil.getInteger("econtainer.query.timeout", 120), (TimeUnit)TimeUnit.MINUTES);
    }

    private boolean analysisResult(String result) {
        String taskDetailJson = this.getTaskDetailJson(result);
        log.info("analysis query result : {}.", (Object)taskDetailJson);
        if (StringUtils.isEmpty((CharSequence)taskDetailJson)) {
            return false;
        }
        this.detailResult = (EcontainerDetailResult)JSON.parseObject((String)taskDetailJson, EcontainerDetailResult.class);
        this.parseDeployEcontainerServiceSubTask();
        String status = Optional.ofNullable(this.detailResult).map(EcontainerDetailResult::getTask).map(EcontainerTaskResult::getStatus).orElse("");
        if ("success".equals(status)) {
            return true;
        }
        if ("failed".equals(status)) {
            log.error("eContainer deploy error");
            throw new EcontainerException(EcontainerError.ECONTAINER_INSTALL_FAILED);
        }
        return false;
    }

    private void parseDeployEcontainerServiceSubTask() {
        Optional.ofNullable(this.detailResult).map(EcontainerDetailResult::getTask).map(EcontainerTaskResult::getCreateTime).ifPresent(startTime -> this.getTaskResult().setStartTime(this.parseDateTime((String)startTime)));
        AtomicInteger index = new AtomicInteger(0);
        this.setSubTasks(Optional.ofNullable(this.detailResult).map(EcontainerDetailResult::getTasklevels).orElse(Collections.emptyList()).stream().peek(levelResult -> levelResult.setIndex(index.getAndIncrement())).map(this::buildSubTask).collect(Collectors.toList()));
    }

    private boolean checkSubTaskAnyStatus(EcontainerTaskLevelResult taskResult, String status) {
        return CollectionUtils.emptyIfNull(taskResult.getSubTaskNodeInfos()).stream().anyMatch(nodeInfo -> Objects.equals(nodeInfo.getStatus(), status));
    }

    private boolean checkSubTaskAllStatus(EcontainerTaskLevelResult taskResult, String status) {
        return CollectionUtils.emptyIfNull(taskResult.getSubTaskNodeInfos()).stream().allMatch(nodeInfo -> Objects.equals(nodeInfo.getStatus(), status));
    }

    private Optional<LocalDateTime> getStartTime(EcontainerTaskLevelResult taskResult) {
        return CollectionUtils.emptyIfNull(taskResult.getSubTaskNodeInfos()).stream().map(EcontainerSubTaskResult::getStartTime).filter(StringUtils::isNotEmpty).min(String::compareTo).map(this::parseDateTime);
    }

    private LocalDateTime parseDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    private Optional<LocalDateTime> getFinishTime(EcontainerTaskLevelResult taskResult) {
        return CollectionUtils.emptyIfNull(taskResult.getSubTaskNodeInfos()).stream().map(EcontainerSubTaskResult::getEndTime).filter(StringUtils::isNotEmpty).max(String::compareTo).map(this::parseDateTime);
    }

    BaseTask buildSubTask(EcontainerTaskLevelResult taskResult) {
        BaseTaskResult result = new BaseTaskResult();
        if (this.checkSubTaskAnyStatus(taskResult, "running")) {
            this.getStartTime(taskResult).ifPresent(arg_0 -> ((BaseTaskResult)result).setStartTime(arg_0));
            result.setTaskStatus(TaskStatus.RUNNING);
        } else if (this.checkSubTaskAnyStatus(taskResult, "failed")) {
            this.getStartTime(taskResult).ifPresent(arg_0 -> ((BaseTaskResult)result).setStartTime(arg_0));
            result.setTaskStatus(TaskStatus.ERROR);
            this.getFinishTime(taskResult).ifPresent(arg_0 -> ((BaseTaskResult)result).setEndTime(arg_0));
        } else if (this.checkSubTaskAllStatus(taskResult, "success")) {
            this.getStartTime(taskResult).ifPresent(arg_0 -> ((BaseTaskResult)result).setStartTime(arg_0));
            result.setTaskStatus(TaskStatus.END);
            this.getFinishTime(taskResult).ifPresent(arg_0 -> ((BaseTaskResult)result).setEndTime(arg_0));
        } else if (this.checkSubTaskAllStatus(taskResult, "ready")) {
            result.setTaskStatus(TaskStatus.NOT_START);
        }
        result.setDetail(new StringBuilder(JSON.toJSONString((Object)taskResult)));
        return ((EcontainerStepTask.EcontainerStepTaskBuilder)((EcontainerStepTask.EcontainerStepTaskBuilder)((EcontainerStepTask.EcontainerStepTaskBuilder)((EcontainerStepTask.EcontainerStepTaskBuilder)EcontainerStepTask.builder().taskId(taskResult.getTaskType())).taskName(taskResult.getDescription())).duration(EcontainerStepTask.getDurationTime(taskResult.getIndex()))).taskResult(result)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTaskDetailJson(String result) {
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(result));){
            String string = bufferedReader.lines().collect(Collectors.toList()).stream().filter(line -> line.startsWith("{") && line.endsWith("}")).findFirst().orElse("");
            return string;
        }
        catch (IOException e) {
            throw new EcontainerException(EcontainerError.ECONTAINER_QUERY_DETAIL_FAILED);
        }
    }

    String getResult() {
        try {
            SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(this.cmd.getSshCmd());
            ExecuteSshCommandUtils.executeDeployEcontainerDeploy(SshDeployEcontainerCmd.builder().sshShellService(sshClient).userName("admin").password(this.cmd.getAdminPwd()).ip(this.cmd.getSshCmd().getIp()).cmd("sh /home/install/eContainerInstaller/smartKit/query.sh").build());
            String result = ExecuteSshCommandUtils.executeCommand(sshClient, "cat /home/install/eContainerInstaller/smartKit/result.txt", false);
            this.querySshFailedCnt = 0;
            return result;
        }
        catch (SshException e) {
            ++this.querySshFailedCnt;
            log.error("query deploy progress failed, count : {},", (Object)this.querySshFailedCnt, (Object)e);
            if (this.querySshFailedCnt > 15) {
                throw new EcontainerException(EcontainerError.ECONTAINER_SSH_FAILED, Collections.singletonList(e.getErrorMessage()));
            }
            return "";
        }
    }

    public void afterExecute() {
        if (TaskStatus.END.equals((Object)this.getTaskResult().getTaskStatus())) {
            try {
                SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(this.cmd.getSshCmd());
                String result = ExecuteSshCommandUtils.executeCommand(sshClient, "sh /home/install/eContainerInstaller/stop.sh", false);
                log.info("stop container installer result :{}", (Object)result);
                String removeResult = ExecuteSshCommandUtils.executeCommand(sshClient, "rm -rf /home/install");
                log.info("remove installer result :{}", (Object)removeResult);
            }
            catch (SshException e) {
                log.warn("remove install error", (Throwable)e);
            }
        }
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    @Generated
    protected QueryEcontainerDeployTask(QueryEcontainerDeployTaskBuilder<?, ?> b) {
        super(b);
        this.querySshFailedCnt = ((QueryEcontainerDeployTaskBuilder)b).querySshFailedCnt;
        this.cmd = ((QueryEcontainerDeployTaskBuilder)b).cmd;
        this.detailResult = ((QueryEcontainerDeployTaskBuilder)b).detailResult;
    }

    @Generated
    public static QueryEcontainerDeployTaskBuilder<?, ?> builder() {
        return new QueryEcontainerDeployTaskBuilderImpl();
    }

    @Generated
    private static final class QueryEcontainerDeployTaskBuilderImpl
    extends QueryEcontainerDeployTaskBuilder<QueryEcontainerDeployTask, QueryEcontainerDeployTaskBuilderImpl> {
        @Generated
        private QueryEcontainerDeployTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryEcontainerDeployTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QueryEcontainerDeployTask build() {
            return new QueryEcontainerDeployTask(this);
        }
    }

    @Generated
    public static abstract class QueryEcontainerDeployTaskBuilder<C extends QueryEcontainerDeployTask, B extends QueryEcontainerDeployTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private int querySshFailedCnt;
        @Generated
        private QueryEcontainerDeploymentCmd cmd;
        @Generated
        private EcontainerDetailResult detailResult;

        @Generated
        public B querySshFailedCnt(int querySshFailedCnt) {
            this.querySshFailedCnt = querySshFailedCnt;
            return (B)this.self();
        }

        @Generated
        public B cmd(QueryEcontainerDeploymentCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        public B detailResult(EcontainerDetailResult detailResult) {
            this.detailResult = detailResult;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "QueryEcontainerDeployTask.QueryEcontainerDeployTaskBuilder(super=" + super.toString() + ", querySshFailedCnt=" + this.querySshFailedCnt + ", cmd=" + this.cmd + ", detailResult=" + this.detailResult + ")";
        }
    }
}

