/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import com.huawei.smartkit.drop.util.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerFile;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.SshDeployEcontainerCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask.StartEcontainerDeploymentCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerConfigUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEcontainerDeploymentTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartEcontainerDeploymentTask.class);
    public static final String NAME = "start.eContainer.deploy.task";
    private static final Pattern ADDR_NUM_PATTERN = Pattern.compile("\u3010(\\d+)\u3011");
    private final StartEcontainerDeploymentCmd cmd;

    public void execute() throws TaskException {
        try {
            SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(this.cmd.getSshCmd());
            this.prepareEnv(sshClient);
            this.startDeploy(sshClient);
        }
        catch (SshException e) {
            log.info("start deploy failed.", (Throwable)e);
            throw new EcontainerException(EcontainerError.ECONTAINER_SSH_FAILED, Collections.singletonList(e.getErrorMessage()));
        }
    }

    public void afterExecute() {
        super.afterExecute();
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    void startDeploy(SshShellService sshClient) throws SshException {
        int waitTime = EcontainerConfigUtil.getInteger("econtainer.start.installer.wait.time", 5);
        log.info("wait for starting eContainer installer, time : {}.", (Object)waitTime);
        ThreadUtils.threadSafeSleep((int)waitTime, (TimeUnit)TimeUnit.MINUTES);
        log.info("start to deploy k8s, ip : {}.", (Object)this.cmd.getSshCmd().getIp());
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /home/install/eContainerInstaller/smartKit");
        String startResult = ExecuteSshCommandUtils.executeDeployEcontainerDeploy(SshDeployEcontainerCmd.builder().sshShellService(sshClient).userName("admin").password(this.cmd.getAdminPwd()).ip(this.cmd.getSshCmd().getIp()).cmd("sh /home/install/eContainerInstaller/smartKit/start.sh").param(Base64.encode((CharSequence)JSON.toJSONString((Object)this.cmd.getEntity()), (Charset)StandardCharsets.UTF_8)).build());
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /home/install");
        if (this.startFailed(startResult)) {
            throw new EcontainerException(EcontainerError.START_CREATE_CLUSTER_FAILED);
        }
    }

    private void prepareEnv(SshShellService sshClient) throws SshException {
        log.info("start to change dir to gandalf home.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"cd %s", (Object[])new Object[]{"/home/manageromm"}));
        EcontainerFile file = this.cmd.getFile();
        log.info("start to mv installer to install dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"mv %s /home/install", (Object[])new Object[]{file.getEContainerInstaller().getName()}));
        log.info("start to mv meta vision to software dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"mv %s /repo/econtainer/install/software", (Object[])new Object[]{file.getMetaVision().getName()}));
        log.info("start to mv eContainer software to software dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"mv %s /repo/econtainer/install/software", (Object[])new Object[]{file.getEContainerSoftware().getName()}));
        log.info("start to mv k8s to software dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"mv %s /repo/econtainer/install/software", (Object[])new Object[]{file.getK8sSoftware().getName()}));
        log.info("start to mv esdk csi to upload dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"mv %s /repo/econtainer/install/esdkcsi/upload", (Object[])new Object[]{file.getCsi().getName()}));
        log.info("start to tar installer file to install dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.format((String)"tar -xvf /home/install/%s -C /home/install", (Object[])new Object[]{file.getEContainerInstaller().getName()}), false);
        log.info("start to change dir to install dir.");
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /home/install");
        log.info("start to change root permission.");
        sshClient.changeRootPermission(this.cmd.getSshCmd().getRootPassword());
        log.info("start to chmod install permission.");
        ExecuteSshCommandUtils.executeCommand(sshClient, "chmod 750 /home/install");
        log.info("start to chmod econtainer permission.");
        ExecuteSshCommandUtils.executeCommand(sshClient, "chmod 750 -R /repo/econtainer");
        log.info("start to start econtainer installer.");
        String startServiceResult = ExecuteSshCommandUtils.executeCommand(sshClient, "sh /home/install/eContainerInstaller/start.sh", false);
        log.info("start to select network ip address.");
        String addrNum = this.parseAddrNum(startServiceResult, this.cmd.getSshCmd().getIp());
        log.info("parse addnum result: {}", (Object)addrNum);
        String result = ExecuteSshCommandUtils.executeCommand(sshClient, addrNum, false);
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"successful"})) {
            throw new EcontainerException(EcontainerError.ECONTAINER_INSTALLER_START);
        }
    }

    private boolean startFailed(String startResult) {
        String startSuccessKeywords = EcontainerConfigUtil.getString("start.create.cluster.success");
        log.info("start success key :{}", (Object)startSuccessKeywords);
        return StringUtils.isEmpty((CharSequence)startResult) || !startResult.contains(startSuccessKeywords);
    }

    private String parseAddrNum(String result, String mgmtIp) {
        return Stream.of(result.split("\\n")).filter(line -> line.contains(mgmtIp)).map(ADDR_NUM_PATTERN::matcher).filter(Matcher::find).map(Matcher::group).map(num -> num.substring(1, num.length() - 1)).findFirst().orElse("0");
    }

    @Generated
    protected StartEcontainerDeploymentTask(StartEcontainerDeploymentTaskBuilder<?, ?> b) {
        super(b);
        this.cmd = ((StartEcontainerDeploymentTaskBuilder)b).cmd;
    }

    @Generated
    public static StartEcontainerDeploymentTaskBuilder<?, ?> builder() {
        return new StartEcontainerDeploymentTaskBuilderImpl();
    }

    @Generated
    private static final class StartEcontainerDeploymentTaskBuilderImpl
    extends StartEcontainerDeploymentTaskBuilder<StartEcontainerDeploymentTask, StartEcontainerDeploymentTaskBuilderImpl> {
        @Generated
        private StartEcontainerDeploymentTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected StartEcontainerDeploymentTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StartEcontainerDeploymentTask build() {
            return new StartEcontainerDeploymentTask(this);
        }
    }

    @Generated
    public static abstract class StartEcontainerDeploymentTaskBuilder<C extends StartEcontainerDeploymentTask, B extends StartEcontainerDeploymentTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private StartEcontainerDeploymentCmd cmd;

        @Generated
        public B cmd(StartEcontainerDeploymentCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StartEcontainerDeploymentTask.StartEcontainerDeploymentTaskBuilder(super=" + super.toString() + ", cmd=" + this.cmd + ")";
        }
    }
}

