/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerFile;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerError;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.task.subtask.UploadEcontainerSoftwareCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadSoftwareTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadSoftwareTask.class);
    public static final String NAME = "upload.software.task";
    private final UploadEcontainerSoftwareCmd cmd;

    public void execute() throws TaskException {
        try {
            SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(this.cmd.getSshCmd());
            log.info("start clean dir and create again.");
            ExecuteSshCommandUtils.executeCommand(sshClient, "rm -rf /home/manageromm/*");
            ExecuteSshCommandUtils.executeCommand(sshClient, "rm -rf /home/install");
            ExecuteSshCommandUtils.executeCommand(sshClient, "rm -rf /repo/econtainer/install/software");
            ExecuteSshCommandUtils.executeCommand(sshClient, "rm -rf /repo/econtainer/install/esdkcsi/upload");
            ExecuteSshCommandUtils.executeCommand(sshClient, "mkdir -p /home/install");
            ExecuteSshCommandUtils.executeCommand(sshClient, "mkdir -p /repo/econtainer/install/software");
            ExecuteSshCommandUtils.executeCommand(sshClient, "mkdir -p /repo/econtainer/install/esdkcsi/upload");
            this.uploadSoftware();
        }
        catch (SshException e) {
            log.error("execute upload software package failed", (Throwable)e);
            throw new EcontainerException(EcontainerError.UPLOAD_FILE);
        }
    }

    public void afterExecute() {
        super.afterExecute();
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    private void uploadSoftware() throws SshException {
        log.info("start upload software");
        SshSftpService sshSftpService = SshSessionKeepContext.getInstance().getSshSftpService(this.cmd.getSshCmd());
        EcontainerFile file = this.cmd.getFile();
        log.info("start to upload k8s software.");
        sshSftpService.upload(file.getK8sSoftware(), "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(file.getK8sSoftware().getName(), (type, detail) -> this.appendTaskDetail((String)detail)));
        log.info("start to upload meta vision software.");
        sshSftpService.upload(file.getMetaVision(), "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(file.getMetaVision().getName(), (type, detail) -> this.appendTaskDetail((String)detail)));
        log.info("start to upload eContainer software.");
        sshSftpService.upload(file.getEContainerSoftware(), "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(file.getEContainerSoftware().getName(), (type, detail) -> this.appendTaskDetail((String)detail)));
        log.info("start to upload installer software.");
        sshSftpService.upload(file.getEContainerInstaller(), "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(file.getEContainerInstaller().getName(), (type, detail) -> this.appendTaskDetail((String)detail)));
        log.info("start to upload csi software.");
        sshSftpService.upload(file.getCsi(), "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(file.getCsi().getName(), (type, detail) -> this.appendTaskDetail((String)detail)));
        log.info("finish upload software");
    }

    @Generated
    protected UploadSoftwareTask(UploadSoftwareTaskBuilder<?, ?> b) {
        super(b);
        this.cmd = ((UploadSoftwareTaskBuilder)b).cmd;
    }

    @Generated
    public static UploadSoftwareTaskBuilder<?, ?> builder() {
        return new UploadSoftwareTaskBuilderImpl();
    }

    @Generated
    private static final class UploadSoftwareTaskBuilderImpl
    extends UploadSoftwareTaskBuilder<UploadSoftwareTask, UploadSoftwareTaskBuilderImpl> {
        @Generated
        private UploadSoftwareTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadSoftwareTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadSoftwareTask build() {
            return new UploadSoftwareTask(this);
        }
    }

    @Generated
    public static abstract class UploadSoftwareTaskBuilder<C extends UploadSoftwareTask, B extends UploadSoftwareTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private UploadEcontainerSoftwareCmd cmd;

        @Generated
        public B cmd(UploadEcontainerSoftwareCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UploadSoftwareTask.UploadSoftwareTaskBuilder(super=" + super.toString() + ", cmd=" + this.cmd + ")";
        }
    }
}

