/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils;

import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.SshDeployEcontainerCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageType;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class ExecuteSshCommandUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteSshCommandUtils.class);

    public static String executeCommand(SshShellService sshClient, String cmd) throws SshException {
        return ExecuteSshCommandUtils.executeCommand(sshClient, cmd, true);
    }

    public static String executeCommand(SshShellService sshClient, String cmd, boolean checkResult) throws SshException {
        log.info("cmd is {}", (Object)cmd);
        String result = sshClient.execCommand(cmd);
        log.info("result is {}", (Object)result);
        if (checkResult && SshErrParser.isInvalidResult((String)result)) {
            throw new SshException((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList(cmd));
        }
        return result;
    }

    public static boolean checkPodInstallResult(SshShellService sshClient, String yamlPath) throws SshException {
        Optional<String> opDaemonSetName = ExecuteSshCommandUtils.parseYamlDaemonSetName(yamlPath);
        if (!opDaemonSetName.isPresent()) {
            log.error("check pod daemon name is empty, yaml : {}.", (Object)yamlPath);
            return false;
        }
        String daemonSetName = opDaemonSetName.get();
        log.info("start to check daemon name : {}.", (Object)daemonSetName);
        AtomicBoolean checkPodStatus = new AtomicBoolean(false);
        RetryUtils.retry(() -> ExecuteSshCommandUtils.queryPodStatus(sshClient, daemonSetName), opResult -> ExecuteSshCommandUtils.checkStatusShouldStop(daemonSetName, checkPodStatus, opResult), (int)15, (TimeUnit)TimeUnit.MINUTES);
        return checkPodStatus.get();
    }

    private static boolean checkStatusShouldStop(String daemonSetName, AtomicBoolean checkPodStatus, Optional<String> opResult) {
        if (!opResult.isPresent()) {
            log.error("check pod status cmd failed. stop continue to query.");
            checkPodStatus.set(false);
            return true;
        }
        if (ExecuteSshCommandUtils.checkPodStatusAllRunning(daemonSetName, opResult.get())) {
            log.error("check pod status success. stop continue to query.");
            checkPodStatus.set(true);
            return true;
        }
        return false;
    }

    private static boolean checkPodStatusAllRunning(String daemonSetName, String result) {
        List componentStatus = Arrays.stream(result.split("\n")).filter(line -> !line.contains("grep") && line.contains(daemonSetName)).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(componentStatus) && componentStatus.stream().allMatch(line -> line.contains("Running"));
    }

    private static Optional<String> queryPodStatus(SshShellService sshClient, String daemonSetName) {
        try {
            String cmd = "kubectl get pod -A -o custom-columns=NAME:.metadata.name,STATUS:.status.phase | grep " + daemonSetName;
            return Optional.ofNullable(ExecuteSshCommandUtils.executeCommand(sshClient, cmd));
        }
        catch (SshException e) {
            log.warn("query pod status ssh cmd failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> parseYamlDaemonSetName(String yamlPath) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        try (InputStream inputStream = Files.newInputStream(new File(yamlPath).toPath(), new OpenOption[0]);){
            Object yamlDoc;
            Optional<String> optionalName;
            Iterator iterator = yaml.loadAll(inputStream).iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
                yamlDoc = iterator.next();
            } while (!(optionalName = Optional.ofNullable(yamlDoc).filter(HashMap.class::isInstance).map(HashMap.class::cast).filter(yamlMap -> Objects.equals("DaemonSet", yamlMap.get("kind"))).map(yamlMap -> yamlMap.get("metadata")).filter(HashMap.class::isInstance).map(HashMap.class::cast).map(yamlMap -> yamlMap.get("name")).filter(String.class::isInstance).map(String.class::cast)).isPresent());
            Optional<String> optional = optionalName;
            return optional;
        }
        catch (IOException e) {
            log.error("parse yaml {} failed.", (Object)yamlPath, (Object)e);
        }
        return Optional.empty();
    }

    public static String executeDeployEcontainerDeploy(SshDeployEcontainerCmd sshCmd) throws SshException {
        String shellCmd = sshCmd.getCmd().concat(" ").concat(sshCmd.getIp());
        SshShellService sshShellService = sshCmd.getSshShellService();
        String result = sshShellService.execCommand(shellCmd);
        log.info("execute start or query command : {}, result : {}.", (Object)shellCmd, (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"enter user name"})) {
            result = sshShellService.execCommand(sshCmd.getUserName());
            log.info("execute username command : {}, result : {}{}.", new Object[]{shellCmd, result, LogFilterMark.INSENSITIVE});
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"enter your password"})) {
            result = sshShellService.execCommand(sshCmd.getPassword());
            log.info("execute pwd command : {}, result : {}{}.", new Object[]{shellCmd, result, LogFilterMark.INSENSITIVE});
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"enter your param"})) {
            result = sshShellService.execCommand(StringUtils.defaultString((String)sshCmd.getParam()));
            log.info("execute param command : {}, result : {}{}.", new Object[]{shellCmd, result, LogFilterMark.INSENSITIVE});
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"enter your locale"})) {
            String language = LanguageUtils.getCurrentLanguage() == LanguageType.EN ? "en_US" : "zh_CN";
            result = sshShellService.execCommand(language);
            log.info("execute current local : {}, result : {}{}.", new Object[]{language, result, LogFilterMark.INSENSITIVE});
        }
        return result;
    }

    @Generated
    private ExecuteSshCommandUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

