/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube;

import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.FusionCubeRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.CommResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.InitStatusInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.LoginData;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.LoginResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MetaVisionInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ModifyPwdInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.QueryDeviceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.QueryManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.SslSwitchInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.TaskDetailInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.http.LoggerInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class FusionCubeReqClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionCubeReqClient.class);
    private final MetaVisionInfo metaVisionInfo = new MetaVisionInfo();
    private String token;
    private final FusionCubeRequestApi requestApi;

    public FusionCubeReqClient(MetaVisionInfo info) {
        this.metaVisionInfo.setManageIp(info.getManageIp()).setAdminPwd(info.getAdminPwd()).setOrgAdminPwd(info.getOrgAdminPwd());
        String url = StringUtils.formatTxt((String)"https://%s:443", (Object[])new Object[]{info.getManageIp()});
        this.requestApi = (FusionCubeRequestApi)HttpRequestApiFactory.createRequestApi((String)url, FusionCubeRequestApi.class, (Interceptor[])new Interceptor[]{new LoggerInterceptor()});
    }

    public Optional<String> manageDevice(@NotNull List<ManageDevice> device) {
        try {
            if (CollectionUtils.isEmpty(device) || !this.checkHasLogin()) {
                log.error("login in manage failed, size : {}.", (Object)device.size());
                return Optional.empty();
            }
            log.info("start to manage device, size:{}, name : {}, type:{}", new Object[]{device.size(), device.get(0).getDeviceName(), device.get(0).getDeviceModel()});
            return this.parseResponse(this.requestApi.manageDevice(this.buildHeaders(), device).execute()).map(maps -> (String)maps.get("taskId"));
        }
        catch (IOException e) {
            log.error("manage device failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    public List<QueryManageDevice> queryManageDevices(@NotNull Set<String> deviceTypes) {
        try {
            if (CollectionUtils.isEmpty(deviceTypes) || !this.checkHasLogin()) {
                log.error("query manage device failed, size : {}.", (Object)deviceTypes.size());
                return Collections.emptyList();
            }
            log.info("start to query device, type:{}", deviceTypes);
            HashMap<String, List<String>> bodyMaps = new HashMap<String, List<String>>();
            bodyMaps.put("deviceTypes", new ArrayList<String>(deviceTypes));
            return this.parseResponse(this.requestApi.queryDeviceAccount(this.buildHeaders(), bodyMaps).execute()).filter(deviceInfo -> deviceInfo.getTotal() > 0).map(QueryDeviceInfo::getDataList).orElse(Collections.emptyList());
        }
        catch (IOException e) {
            log.error("query manage device failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean deleteDevices(@NotNull Set<String> deviceIds) {
        try {
            if (CollectionUtils.isEmpty(deviceIds) || !this.checkHasLogin()) {
                log.error("delete manage device failed, size : {}.", (Object)deviceIds.size());
                return false;
            }
            log.info("start to delete manage device, ids : {}.", deviceIds);
            return this.isResponseSuccessful(this.requestApi.deleteDevice(this.buildHeaders(), deviceIds).execute());
        }
        catch (IOException e) {
            log.error("delete device failed.", (Throwable)e);
            return false;
        }
    }

    public Optional<TaskDetailInfo> queryManageDeviceResult(String taskId) {
        log.info("prepare to query manage device task : {}.", (Object)taskId);
        if (StringUtils.isEmpty((CharSequence)taskId) || !this.checkHasLogin()) {
            return Optional.empty();
        }
        try {
            return this.parseResponse(this.requestApi.queryManageDevTaskDetail(this.buildHeaders(), taskId).execute());
        }
        catch (IOException e) {
            log.error("query manage device failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean modifyLogoIcon(String field, @NotNull File logoFile) {
        try {
            if (!logoFile.exists() || !this.checkHasLogin()) {
                log.error("login in modify logo icon failed, name : {}.", (Object)logoFile.getName());
                return false;
            }
            log.info("start to modify logo icon, logo : {}.", (Object)logoFile.getName());
            Optional opModifyResult = this.parseResponse(this.requestApi.modifyLogoOrIcon(this.buildHeaders(), field, MultipartBody.Part.createFormData((String)"image", (String)logoFile.getName(), (RequestBody)RequestBody.create((File)logoFile, (MediaType)MediaType.parse((String)"image/png")))).execute());
            return opModifyResult.isPresent() && (Boolean)opModifyResult.get() != false;
        }
        catch (IOException e) {
            log.error("manage device failed.", (Throwable)e);
            return false;
        }
    }

    public boolean login() {
        Optional<LoginResult> loginResult = this.tryToLogin(this.metaVisionInfo.getAdminPwd());
        if (!loginResult.isPresent()) {
            loginResult = this.tryToLogin(this.metaVisionInfo.getOrgAdminPwd());
        }
        if (loginResult.isPresent() && loginResult.get().isNeedChangePwd()) {
            boolean result = this.updateToken(loginResult.get()) && this.modifyUserPwd();
            log.info("parse token and modify pwd result : {}.", (Object)result);
            if (result) {
                log.info("try to re login by new pwd.");
                loginResult = this.tryToLogin(this.metaVisionInfo.getAdminPwd());
            }
        }
        return loginResult.isPresent() && this.updateToken(loginResult.get());
    }

    private boolean updateToken(LoginResult loginResult) {
        if (StringUtils.isNotEmpty((CharSequence)loginResult.getToken())) {
            this.token = loginResult.getToken();
            return true;
        }
        return false;
    }

    private Optional<LoginResult> tryToLogin(String password) {
        try {
            return this.parseResponse(this.requestApi.login(new LoginData().setUsername("admin").setPassword(password)).execute());
        }
        catch (IOException e) {
            log.error("try to login failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean modifyUserPwd() {
        try {
            return this.isResponseSuccessful(this.requestApi.modifyPassword(this.buildHeaders(), ModifyPwdInfo.builder().orignalPassword(this.metaVisionInfo.getOrgAdminPwd()).newPassword(this.metaVisionInfo.getAdminPwd()).build()).execute());
        }
        catch (IOException e) {
            log.error("modify pwd failed.", (Throwable)e);
            return false;
        }
    }

    public boolean updateInitStatus() {
        try {
            return this.isResponseSuccessful(this.requestApi.updateInitializeStatus(this.buildHeaders(), InitStatusInfo.builder().build()).execute());
        }
        catch (IOException e) {
            log.error("update init status failed.", (Throwable)e);
            return false;
        }
    }

    public boolean handleSslSwitch(boolean isOpen) {
        SslSwitchInfo switchInfo = new SslSwitchInfo();
        switchInfo.setOpened(isOpen);
        try {
            return this.isResponseSuccessful(this.requestApi.handleSslSwitch(this.buildHeaders(), switchInfo).execute());
        }
        catch (IOException e) {
            log.error("handle ssl switch failed.", (Throwable)e);
            return false;
        }
    }

    public boolean logout() {
        try {
            if (StringUtils.isEmpty((CharSequence)this.token)) {
                log.warn("token is empty, not need to logout.");
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isResponseSuccessful(this.requestApi.logout(this.buildHeaders()).execute());
            return bl;
        }
        catch (IOException e) {
            log.error("logout failed.", (Throwable)e);
        }
        finally {
            log.info("clear login token.");
            this.token = "";
        }
        return false;
    }

    private <T> Optional<T> parseResponse(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            log.warn("response failed, response:{}.", response);
            return Optional.empty();
        }
        CommResponse commResponse = (CommResponse)response.body();
        if (Objects.nonNull(commResponse) && commResponse.isSuccessfully()) {
            return Optional.ofNullable(commResponse.getData());
        }
        return Optional.empty();
    }

    private <T> boolean isResponseSuccessful(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            return false;
        }
        CommResponse commResponse = (CommResponse)response.body();
        return Objects.nonNull(commResponse) && commResponse.isSuccessfully();
    }

    private boolean checkHasLogin() {
        return StringUtils.isNotEmpty((CharSequence)this.token);
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", this.token);
        return headers;
    }
}

