/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.BasicDevInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.BmcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ExtFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.IpPortFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevInterface;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.SnmpV3;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class ServerInfo
extends BasicDevInfo
implements ManageDevInterface {
    private static final Map<String, String> DEVICE_MODE_MAP = ImmutableMap.of((Object)"Atlas 800 (Model 3000)", (Object)"Atlas 800 3000", (Object)"FusionCube 1000H", (Object)"DPE 60000");
    private static final List<String> INFERENCE_SERVER_LIST = ImmutableList.of((Object)"Atlas 800I A2");
    private String name;
    private String sn;
    private String nodeType;
    private String managerIp;
    private String businessIp;
    private String interconnectPwd;
    private String gandalfPwd;
    private String storageIp;
    private BmcInfo bmcInfo;

    @Override
    public List<ManageDevice> toManageDevice() {
        return Arrays.asList(((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)ManageDevice.builder().deviceName(this.name)).deviceModel(DEVICE_MODE_MAP.getOrDefault(this.getModel(), this.getModel()))).cabinetRelation("outside")).deviceSubType("")).deviceType("server")).cabinetNo(this.getCabinetNo())).roleType(INFERENCE_SERVER_LIST.contains(this.getModel()) ? "INFERENCE_SERVER" : "TRAIN_INFERENCE_SERVER")).realRoleType(this.nodeType.toUpperCase(Locale.ROOT))).cabinetPosition(String.valueOf(this.getSlotId()))).slot(String.valueOf(this.getSlotId()))).ipPortFeatures(this.buildIbmcIpFeatures())).extFeatures(this.buildIbmcExtFeatures())).snmpV3(this.buildSnmpV3())).build(), ((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)ManageDevice.builder().deviceName("fsa-" + this.name)).deviceModel("Fsa")).deviceType("fsa")).cabinetRelation("none")).deviceSubType("")).realRoleType(this.nodeType.toUpperCase(Locale.ROOT))).ipPortFeatures(this.buildOsIpFeatures())).extFeatures(this.buildOsExtFeatures())).build());
    }

    private List<ExtFeature> buildIbmcExtFeatures() {
        return Arrays.asList(ExtFeature.builder().extKey("serialNumber").extValue(this.sn).build(), ExtFeature.builder().extKey("fc2mgmtEnabled").extValue("false").build());
    }

    private List<ExtFeature> buildOsExtFeatures() {
        LinkedList<ExtFeature> features = new LinkedList<ExtFeature>(Arrays.asList(ExtFeature.builder().extKey("serialNumber").extValue(this.sn).build(), ExtFeature.builder().extKey("managerommEnabled").extValue("false").build(), ExtFeature.builder().extKey("managerEnabled").extValue("false").build(), ExtFeature.builder().extKey("managersftpEnabled").extValue("false").build(), ExtFeature.builder().extKey("rootEnabled").extValue("false").build(), ExtFeature.builder().extKey("gandalfEnabled").extValue("false").build()));
        if (StringUtils.isNotEmpty((CharSequence)this.businessIp)) {
            features.add(ExtFeature.builder().extKey("businessIp").extValue(this.businessIp).build());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.storageIp)) {
            features.add(ExtFeature.builder().extKey("storageIp").extValue(this.storageIp).build());
        }
        return features;
    }

    private List<IpPortFeature> buildIbmcIpFeatures() {
        return Collections.singletonList(IpPortFeature.builder().ip(this.bmcInfo.getTargetIp()).opType("ibmc").userName("fc2mgmt").password(this.bmcInfo.getFc2mgmtPwd()).port(443).build());
    }

    private List<IpPortFeature> buildOsIpFeatures() {
        return Arrays.asList(IpPortFeature.builder().ip(this.managerIp).opType("ssh").userName("manageromm").port(22).password(this.interconnectPwd).build(), IpPortFeature.builder().ip(this.managerIp).opType("ssh_operation").userName("manager").port(22).password(this.interconnectPwd).build(), IpPortFeature.builder().ip(this.managerIp).opType("ssh_sftp").userName("managersftp").port(22).password(this.interconnectPwd).build());
    }

    private SnmpV3 buildSnmpV3() {
        return SnmpV3.builder().ip(this.bmcInfo.getTargetIp()).secName("fc2mgmt").port(161).authProtocol("SHA").authPassword(this.bmcInfo.getFc2mgmtPwd()).securityLevel("authPriv").priProtocol("AES_128").encryptPassword(this.bmcInfo.getFc2mgmtPwd()).build();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSn() {
        return this.sn;
    }

    @Generated
    public String getNodeType() {
        return this.nodeType;
    }

    @Generated
    public String getManagerIp() {
        return this.managerIp;
    }

    @Generated
    public String getBusinessIp() {
        return this.businessIp;
    }

    @Generated
    public String getInterconnectPwd() {
        return this.interconnectPwd;
    }

    @Generated
    public String getGandalfPwd() {
        return this.gandalfPwd;
    }

    @Generated
    public String getStorageIp() {
        return this.storageIp;
    }

    @Generated
    public BmcInfo getBmcInfo() {
        return this.bmcInfo;
    }

    @Generated
    public ServerInfo setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ServerInfo setSn(String sn) {
        this.sn = sn;
        return this;
    }

    @Generated
    public ServerInfo setNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    @Generated
    public ServerInfo setManagerIp(String managerIp) {
        this.managerIp = managerIp;
        return this;
    }

    @Generated
    public ServerInfo setBusinessIp(String businessIp) {
        this.businessIp = businessIp;
        return this;
    }

    @Generated
    public ServerInfo setInterconnectPwd(String interconnectPwd) {
        this.interconnectPwd = interconnectPwd;
        return this;
    }

    @Generated
    public ServerInfo setGandalfPwd(String gandalfPwd) {
        this.gandalfPwd = gandalfPwd;
        return this;
    }

    @Generated
    public ServerInfo setStorageIp(String storageIp) {
        this.storageIp = storageIp;
        return this;
    }

    @Generated
    public ServerInfo setBmcInfo(BmcInfo bmcInfo) {
        this.bmcInfo = bmcInfo;
        return this;
    }
}

