/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.BasicDevInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ExtFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.InterconnectInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.IpPortFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevInterface;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.StorageLogicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.CabinetHelper;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class StorageInfo
extends BasicDevInfo
implements ManageDevInterface {
    private static final Map<String, String> DEVICE_MODE_MAP = ImmutableMap.of((Object)"OceanStor Dorado 2100 V6", (Object)"Dorado Control Cabinet 25SAS 2U");
    private String name;
    private String sn;
    private String currentManageIp;
    private String aManagerIp;
    private String bManagerIp;
    private String username;
    private String loginPwd;
    private InterconnectInfo interconnectInfo;
    private List<StorageLogicInfo> logicInfo;

    @Override
    public List<ManageDevice> toManageDevice() {
        return Collections.singletonList(((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)ManageDevice.builder().deviceName(this.name)).deviceModel(this.getModel())).cabinetRelation("none")).deviceSubType("")).deviceType("dorado")).roleType("STORAGE")).ipPortFeatures(this.buildIpFeatures(this.aManagerIp))).extFeatures(this.buildExtFeatures())).childDevices(this.buildChildDevices())).build());
    }

    private List<ManageDevice> buildChildDevices() {
        ArrayListMultimap cabinetManageIps = ArrayListMultimap.create();
        this.logicInfo.stream().filter(info -> StringUtils.isNotEmpty((CharSequence)info.getManageIp())).forEach(arg_0 -> StorageInfo.lambda$buildChildDevices$1((Multimap)cabinetManageIps, arg_0));
        return cabinetManageIps.asMap().entrySet().stream().filter(entry -> StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getKey()))).map(entry -> this.buildCabinetDevice((String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
    }

    private ManageDevice buildCabinetDevice(String cteName, Collection<StorageLogicInfo> logicInfos) {
        String cabinetSn = this.getLogicInfoFiled(logicInfos, StorageLogicInfo::getSn);
        return ((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)ManageDevice.builder().deviceType("dorado-cabinet")).deviceName(this.name + "-" + cteName)).deviceModel(DEVICE_MODE_MAP.getOrDefault(this.name, "Dorado Control Cabinet 36NVMe 2U"))).roleType("STORAGE")).deviceSubType("")).cabinetRelation("outside")).cabinetNo(CabinetHelper.getCabinetNo(this.getLogicInfoFiled(logicInfos, StorageLogicInfo::getCabinet)))).cabinetPosition(this.buildSlotId(logicInfos))).slot(this.buildSlotId(logicInfos))).associationName(this.name)).extFeatures(this.buildChildExtFeatures(cabinetSn))).childDevices(this.buildCtrlDevices(cteName, logicInfos))).build();
    }

    private String getLogicInfoFiled(Collection<StorageLogicInfo> logicInfos, Function<StorageLogicInfo, String> fieldGetter) {
        return logicInfos.stream().map(fieldGetter).filter(StringUtils::isNotEmpty).findFirst().orElse("");
    }

    private String buildSlotId(Collection<StorageLogicInfo> logicInfos) {
        return logicInfos.stream().map(StorageLogicInfo::getSlotId).filter(slotId -> slotId > 0).map(String::valueOf).findFirst().orElse("");
    }

    private List<ManageDevice> buildCtrlDevices(String cteName, Collection<StorageLogicInfo> logicInfos) {
        return logicInfos.stream().map(info -> ((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)((ManageDevice.ManageDeviceBuilder)ManageDevice.builder().deviceName(this.name + "-" + info.getId())).deviceType("Storage")).deviceModel("Storage")).deviceSubType("Storage")).associationName(this.name + "-" + cteName)).cabinetRelation("none")).extFeatures(this.buildCtrlExtFeatures(info.getIp()))).ipPortFeatures(this.buildIpFeatures(info.getManageIp()))).build()).collect(Collectors.toList());
    }

    private List<ExtFeature> buildCtrlExtFeatures(String storageIp) {
        LinkedList<ExtFeature> features = new LinkedList<ExtFeature>(Arrays.asList(ExtFeature.builder().extKey("fcvAdminEnabled").extValue("false").build(), ExtFeature.builder().extKey("storageEsn").extValue(this.sn).build()));
        if (StringUtils.isNotEmpty((CharSequence)storageIp)) {
            features.add(ExtFeature.builder().extKey("storageIp").extValue(storageIp).build());
        }
        return features;
    }

    private List<ExtFeature> buildChildExtFeatures(String serialNumber) {
        return Arrays.asList(ExtFeature.builder().extKey("serialNumber").extValue(serialNumber).build(), ExtFeature.builder().extKey("storageEsn").extValue(this.sn).build());
    }

    private List<ExtFeature> buildExtFeatures() {
        return Arrays.asList(ExtFeature.builder().extKey("storageEsn").extValue(this.sn).build(), ExtFeature.builder().extKey("adminEnabled").extValue("false").build(), ExtFeature.builder().extKey("fcvAdminEnabled").extValue("false").build());
    }

    private List<IpPortFeature> buildIpFeatures(String manageIp) {
        return Collections.singletonList(IpPortFeature.builder().ip(manageIp).opType("management").userName(this.interconnectInfo.getAccount()).password(this.interconnectInfo.getAccountPwd()).port(8088).build());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSn() {
        return this.sn;
    }

    @Generated
    public String getCurrentManageIp() {
        return this.currentManageIp;
    }

    @Generated
    public String getAManagerIp() {
        return this.aManagerIp;
    }

    @Generated
    public String getBManagerIp() {
        return this.bManagerIp;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getLoginPwd() {
        return this.loginPwd;
    }

    @Generated
    public InterconnectInfo getInterconnectInfo() {
        return this.interconnectInfo;
    }

    @Generated
    public List<StorageLogicInfo> getLogicInfo() {
        return this.logicInfo;
    }

    @Generated
    public StorageInfo setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StorageInfo setSn(String sn) {
        this.sn = sn;
        return this;
    }

    @Generated
    public StorageInfo setCurrentManageIp(String currentManageIp) {
        this.currentManageIp = currentManageIp;
        return this;
    }

    @Generated
    public StorageInfo setAManagerIp(String aManagerIp) {
        this.aManagerIp = aManagerIp;
        return this;
    }

    @Generated
    public StorageInfo setBManagerIp(String bManagerIp) {
        this.bManagerIp = bManagerIp;
        return this;
    }

    @Generated
    public StorageInfo setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public StorageInfo setLoginPwd(String loginPwd) {
        this.loginPwd = loginPwd;
        return this;
    }

    @Generated
    public StorageInfo setInterconnectInfo(InterconnectInfo interconnectInfo) {
        this.interconnectInfo = interconnectInfo;
        return this;
    }

    @Generated
    public StorageInfo setLogicInfo(List<StorageLogicInfo> logicInfo) {
        this.logicInfo = logicInfo;
        return this;
    }

    private static /* synthetic */ void lambda$buildChildDevices$1(Multimap cabinetManageIps, StorageLogicInfo info) {
        cabinetManageIps.put((Object)info.getCteName(), (Object)info);
    }
}

