/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import lombok.Generated;

public enum TakeoverTaskStatus {
    WAIT_RUN("1"),
    WAIT_RETRY("2"),
    START_FAIL("3"),
    RUNNING("4"),
    RUN_FAIL("5"),
    RUN_SUCC("6"),
    RUN_PART_SUCC("7"),
    CANCEL_FAIL("8"),
    CANCEL_SUCC("9"),
    TIMEOUT("10"),
    CANCELING("11");

    private final String status;
    private static final EnumSet<TakeoverTaskStatus> STATUS_CANCELLED;
    private static final EnumSet<TakeoverTaskStatus> STATUS_FAILED;

    public boolean isCancelled() {
        return STATUS_CANCELLED.contains((Object)this);
    }

    public boolean isFailed() {
        return STATUS_FAILED.contains((Object)this);
    }

    public boolean isSuccess() {
        return RUN_SUCC == this;
    }

    public static TakeoverTaskStatus of(String status) {
        return Arrays.stream(TakeoverTaskStatus.values()).filter(taskStatus -> Objects.equals(taskStatus.getStatus(), status)).findFirst().orElse(WAIT_RUN);
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    private TakeoverTaskStatus(String status) {
        this.status = status;
    }

    static {
        STATUS_CANCELLED = EnumSet.of(CANCELING, CANCEL_SUCC, CANCEL_FAIL);
        STATUS_FAILED = EnumSet.of(START_FAIL, RUN_FAIL, RUN_PART_SUCC, TIMEOUT);
    }
}

