/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CabinetHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CabinetHelper.class);
    private static final ConcurrentHashMap<String, Integer> cabinetNameNoMaps = new ConcurrentHashMap();

    public static void reset() {
        log.info("clear all cabinet relations.");
        cabinetNameNoMaps.clear();
    }

    public static void putCabinetNameNoRelation(Map<String, String> cabinetNameNos) {
        log.info("put exist cabinet relations : {}.", cabinetNameNos);
        cabinetNameNos.forEach((key, value) -> cabinetNameNoMaps.put((String)key, NumberUtils.parseInt((String)value, (int)0)));
    }

    public static void addCabinetNameNoRelation(String cabinetName) {
        if (cabinetNameNoMaps.containsKey(cabinetName)) {
            log.info("add exist cabinet, ignore it, name : {}.", (Object)cabinetName);
            return;
        }
        int cabinetNo = CabinetHelper.getNextCabinetNo();
        log.info("add new cabinet, name : {}, No : {}.", (Object)cabinetName, (Object)cabinetNo);
        cabinetNameNoMaps.put(cabinetName, cabinetNo);
    }

    public static String getCabinetNo(String cabinetName) {
        return String.valueOf(cabinetNameNoMaps.getOrDefault(cabinetName, 0));
    }

    private static int getNextCabinetNo() {
        return IntStream.range(1, cabinetNameNoMaps.size() + 1).filter(cabinetNo -> !cabinetNameNoMaps.containsValue(cabinetNo)).findFirst().orElse(cabinetNameNoMaps.size() + 1);
    }

    @Generated
    private CabinetHelper() {
    }
}

