/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MateVisionManageInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.MetaVisionManageTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.CabinetTakeoverTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.DoradoTakeoverTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.ModifyLogoTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.ServerTakeoverTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.SwitchTakeoverTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.UpdateInitStatusTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetaVisionManageClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaVisionManageClient.class);
    private static final String EVENT_TYPE = "metaVisionManageEvent";

    public boolean startMetaVisionManage(String taskId, MateVisionManageInfo info) {
        CommonTaskManager.getInstance().addTask((BaseTask)this.createMetaVisionManageTask(taskId, info));
        return CommonTaskManager.getInstance().startTaskById(taskId);
    }

    public Optional<DeployTaskInfoVo> queryMetaVisionManageTask(String taskId) {
        return CommonTaskManager.getInstance().queryTaskDetailById(taskId);
    }

    public MetaVisionManageTask createMetaVisionManageTask(String taskId, MateVisionManageInfo info) {
        List<BaseTask> subTasks = Arrays.asList(new BaseTask[]{this.createCabinetTakeoverTask(info), this.createSwitchTakeoverTask(info), this.createServerTakeoverTask(info), this.createDoradoTakeoverTask(info), this.createModifyLogoTask(info), this.createUpdateInitStatusTask(info)});
        return ((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)((MetaVisionManageTask.MetaVisionManageTaskBuilder)MetaVisionManageTask.builder().taskId(taskId)).taskName(TaskResourceUtils.getMetaVisionManageTaskName("metavision.manage"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("metavision.manage"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("metavision.manage"))).eventType(EVENT_TYPE)).subTasks(subTasks)).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    private CabinetTakeoverTask createCabinetTakeoverTask(MateVisionManageInfo info) {
        return ((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)((Object)((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)((Object)((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)((CabinetTakeoverTask.CabinetTakeoverTaskBuilder)CabinetTakeoverTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("cabinet.tokeover.task"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("cabinet.tokeover.task"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("cabinet.tokeover.task"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).mateVisionManageInfo(info))).build();
    }

    private SwitchTakeoverTask createSwitchTakeoverTask(MateVisionManageInfo info) {
        return ((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)((Object)((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)((Object)((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)((SwitchTakeoverTask.SwitchTakeoverTaskBuilder)SwitchTakeoverTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("switch.tokeover.task"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("switch.tokeover.task"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("switch.tokeover.task"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).switchInfos(info.getSwitchInfos()))).build();
    }

    private ServerTakeoverTask createServerTakeoverTask(MateVisionManageInfo info) {
        return ((ServerTakeoverTask.ServerTakeoverTaskBuilder)((Object)((ServerTakeoverTask.ServerTakeoverTaskBuilder)((Object)((ServerTakeoverTask.ServerTakeoverTaskBuilder)((ServerTakeoverTask.ServerTakeoverTaskBuilder)((ServerTakeoverTask.ServerTakeoverTaskBuilder)((ServerTakeoverTask.ServerTakeoverTaskBuilder)ServerTakeoverTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("server.tokeover.task"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("server.tokeover.task"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("server.tokeover.task"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).serverInfos(info.getServerInfos()))).build();
    }

    private DoradoTakeoverTask createDoradoTakeoverTask(MateVisionManageInfo info) {
        return ((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)((Object)((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)((Object)((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)((DoradoTakeoverTask.DoradoTakeoverTaskBuilder)DoradoTakeoverTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("dorado.tokeover.task"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("dorado.tokeover.task"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("dorado.tokeover.task"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).storageInfos(info.getStorageInfo()))).build();
    }

    private ModifyLogoTask createModifyLogoTask(MateVisionManageInfo info) {
        return ((ModifyLogoTask.ModifyLogoTaskBuilder)((Object)((ModifyLogoTask.ModifyLogoTaskBuilder)((Object)((ModifyLogoTask.ModifyLogoTaskBuilder)((Object)((ModifyLogoTask.ModifyLogoTaskBuilder)((ModifyLogoTask.ModifyLogoTaskBuilder)((ModifyLogoTask.ModifyLogoTaskBuilder)((ModifyLogoTask.ModifyLogoTaskBuilder)ModifyLogoTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("modify.logo.task"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("modify.logo.task"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("modify.logo.task"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).logoFile(new File(info.getSoftwarePath(), "logo.png")))).iconFile(new File(info.getSoftwarePath(), "icon.png")))).build();
    }

    private UpdateInitStatusTask createUpdateInitStatusTask(MateVisionManageInfo info) {
        return ((UpdateInitStatusTask.UpdateInitStatusTaskBuilder)((Object)((UpdateInitStatusTask.UpdateInitStatusTaskBuilder)((UpdateInitStatusTask.UpdateInitStatusTaskBuilder)((UpdateInitStatusTask.UpdateInitStatusTaskBuilder)((UpdateInitStatusTask.UpdateInitStatusTaskBuilder)UpdateInitStatusTask.builder().taskName(TaskResourceUtils.getMetaVisionManageTaskName("update.init.status"))).taskDescription(TaskResourceUtils.getMetaVisionManageTaskDesc("update.init.status"))).duration(TaskResourceUtils.getMetaVisionManageTaskDuration("update.init.status"))).eventType(EVENT_TYPE)).metaVisionInfo(info.getMetaVisionInfo()))).build();
    }
}

