/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.FusionCubeReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.BasicDevInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.CabinetInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MateVisionManageInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.StorageLogicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.CabinetHelper;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.TakeoverBaseTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CabinetTakeoverTask
extends TakeoverBaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CabinetTakeoverTask.class);
    public static final String NAME_KEY = "cabinet.tokeover.task";
    private MateVisionManageInfo mateVisionManageInfo;

    @Override
    protected void preTakeoverDevice(FusionCubeReqClient fusionCubeReqClient) {
        super.preTakeoverDevice(fusionCubeReqClient);
        Map<String, String> cabinetNameNoMaps = fusionCubeReqClient.queryManageDevices(Collections.singleton("cabinet")).stream().collect(Collectors.toMap(ManageDevice::getDeviceName, ManageDevice::getCabinetNo));
        log.info("exist cabinet list : {}.", cabinetNameNoMaps);
        CabinetHelper.reset();
        CabinetHelper.putCabinetNameNoRelation(cabinetNameNoMaps);
    }

    @Override
    protected List<ManageDevice> toManageDevice() {
        HashSet cabinetNames = new HashSet();
        cabinetNames.addAll(this.mateVisionManageInfo.getServerInfos().stream().map(BasicDevInfo::getCabinet).collect(Collectors.toSet()));
        cabinetNames.addAll(this.mateVisionManageInfo.getStorageInfo().stream().flatMap(info -> info.getLogicInfo().stream()).map(StorageLogicInfo::getCabinet).collect(Collectors.toSet()));
        cabinetNames.addAll(this.mateVisionManageInfo.getSwitchInfos().stream().map(BasicDevInfo::getCabinet).collect(Collectors.toSet()));
        return cabinetNames.stream().peek(CabinetHelper::addCabinetNameNoRelation).map(cabinetName -> new CabinetInfo().setCabinetName((String)cabinetName)).map(CabinetInfo::toManageDevice).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Generated
    protected CabinetTakeoverTask(CabinetTakeoverTaskBuilder<?, ?> b) {
        super(b);
        this.mateVisionManageInfo = ((CabinetTakeoverTaskBuilder)b).mateVisionManageInfo;
    }

    @Generated
    public static CabinetTakeoverTaskBuilder<?, ?> builder() {
        return new CabinetTakeoverTaskBuilderImpl();
    }

    @Generated
    private static final class CabinetTakeoverTaskBuilderImpl
    extends CabinetTakeoverTaskBuilder<CabinetTakeoverTask, CabinetTakeoverTaskBuilderImpl> {
        @Generated
        private CabinetTakeoverTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected CabinetTakeoverTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CabinetTakeoverTask build() {
            return new CabinetTakeoverTask(this);
        }
    }

    @Generated
    public static abstract class CabinetTakeoverTaskBuilder<C extends CabinetTakeoverTask, B extends CabinetTakeoverTaskBuilder<C, B>>
    extends TakeoverBaseTask.TakeoverBaseTaskBuilder<C, B> {
        @Generated
        private MateVisionManageInfo mateVisionManageInfo;

        @Generated
        public B mateVisionManageInfo(MateVisionManageInfo mateVisionManageInfo) {
            this.mateVisionManageInfo = mateVisionManageInfo;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CabinetTakeoverTask.CabinetTakeoverTaskBuilder(super=" + super.toString() + ", mateVisionManageInfo=" + this.mateVisionManageInfo + ")";
        }
    }
}

