/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.FusionCubeReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MetaVisionInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverError;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyLogoTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyLogoTask.class);
    public static final String NAME_KEY = "modify.logo.task";
    private File logoFile;
    private File iconFile;
    private MetaVisionInfo metaVisionInfo;

    public void execute() throws TaskException {
        if (!this.logoFile.exists() && !this.iconFile.exists()) {
            log.warn("logo and icon file is not exist.");
            return;
        }
        FusionCubeReqClient fusionCubeReqClient = new FusionCubeReqClient(this.metaVisionInfo);
        try {
            boolean result;
            if (!fusionCubeReqClient.login()) {
                log.error("login mv failed.");
                throw new TakeoverException(TakeoverError.LOGIN_MV_FAILED);
            }
            if (this.logoFile.exists() && !(result = fusionCubeReqClient.modifyLogoIcon("logo", this.logoFile))) {
                log.error("modify logo failed.");
                throw new TakeoverException(TakeoverError.MODIFY_LOGO_FAILED);
            }
            if (this.iconFile.exists() && !(result = fusionCubeReqClient.modifyLogoIcon("icon", this.iconFile))) {
                log.error("modify icon failed.");
                throw new TakeoverException(TakeoverError.MODIFY_ICON_FAILED);
            }
        }
        finally {
            fusionCubeReqClient.logout();
        }
    }

    @Generated
    protected ModifyLogoTask(ModifyLogoTaskBuilder<?, ?> b) {
        super(b);
        this.logoFile = ((ModifyLogoTaskBuilder)b).logoFile;
        this.iconFile = ((ModifyLogoTaskBuilder)b).iconFile;
        this.metaVisionInfo = ((ModifyLogoTaskBuilder)b).metaVisionInfo;
    }

    @Generated
    public static ModifyLogoTaskBuilder<?, ?> builder() {
        return new ModifyLogoTaskBuilderImpl();
    }

    @Generated
    private static final class ModifyLogoTaskBuilderImpl
    extends ModifyLogoTaskBuilder<ModifyLogoTask, ModifyLogoTaskBuilderImpl> {
        @Generated
        private ModifyLogoTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ModifyLogoTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModifyLogoTask build() {
            return new ModifyLogoTask(this);
        }
    }

    @Generated
    public static abstract class ModifyLogoTaskBuilder<C extends ModifyLogoTask, B extends ModifyLogoTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private File logoFile;
        @Generated
        private File iconFile;
        @Generated
        private MetaVisionInfo metaVisionInfo;

        @Generated
        public B logoFile(File logoFile) {
            this.logoFile = logoFile;
            return (B)this.self();
        }

        @Generated
        public B iconFile(File iconFile) {
            this.iconFile = iconFile;
            return (B)this.self();
        }

        @Generated
        public B metaVisionInfo(MetaVisionInfo metaVisionInfo) {
            this.metaVisionInfo = metaVisionInfo;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ModifyLogoTask.ModifyLogoTaskBuilder(super=" + super.toString() + ", logoFile=" + this.logoFile + ", iconFile=" + this.iconFile + ", metaVisionInfo=" + this.metaVisionInfo + ")";
        }
    }
}

