/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.http.BmcHttpClient;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerConfigUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.FusionCubeReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.BmcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ServerInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverError;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverException;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask.TakeoverBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class ServerTakeoverTask
extends TakeoverBaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerTakeoverTask.class);
    public static final String NAME_KEY = "server.tokeover.task";
    private static final String USER_NAME = "fc2mgmt";
    private List<ServerInfo> serverInfos;

    public void beforeExecute() {
        super.beforeExecute();
        CollectionUtils.emptyIfNull(this.serverInfos).forEach(this::createInterconnect);
        int waitSyncTime = EcontainerConfigUtil.getInteger("bmc.wait.sync.create.user", 10);
        log.info("wait for sync create iBMC user, time:{}.", (Object)waitSyncTime);
        ThreadUtils.threadSafeSleep((int)waitSyncTime, (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    protected void preTakeoverDevice(FusionCubeReqClient fusionCubeReqClient) {
        if (!fusionCubeReqClient.handleSslSwitch(false)) {
            throw new TakeoverException(TakeoverError.HANDLE_SSL_SWITCH_FAILED);
        }
    }

    @Override
    protected TakeoverError buildDefaultTakeoverError() {
        return TakeoverError.MANAGE_DEVICE_SERVER_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInterconnect(ServerInfo serverInfo) {
        BmcInfo bmcInfo = serverInfo.getBmcInfo();
        BmcHttpClient client = new BmcHttpClient(bmcInfo.getTargetIp());
        try {
            if (!client.login(bmcInfo.getUsername(), bmcInfo.getNewPwd())) {
                throw new TakeoverException(TakeoverError.IBMC_LOGIN_FAILED);
            }
            Map<String, String> users = this.queryUsers(client);
            String userId = users.get(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                log.warn("exist {} user id : {}.", (Object)USER_NAME, (Object)userId);
                return;
            }
            userId = String.valueOf(users.values().stream().map(Integer::parseInt).max(Integer::compareTo).orElse(2) + 1);
            log.info("find max user id : {}.", (Object)userId);
            if (!this.addUser(client, userId, serverInfo.getBmcInfo().getFc2mgmtPwd())) {
                throw new TakeoverException(TakeoverError.IBMC_CREATE_INTERCONNECT_USER_FAILED);
            }
        }
        finally {
            client.logout();
        }
    }

    private Map<String, String> queryUsers(BmcHttpClient client) {
        try {
            Response<Map<String, Object>> response = client.execute((headers, api) -> api.queryUsers(headers));
            if (!response.isSuccessful() || MapUtils.isEmpty((Map)((Map)response.body()))) {
                return Collections.emptyMap();
            }
            Object members = ((Map)response.body()).get("Members");
            if (!List.class.isInstance(members)) {
                return Collections.emptyMap();
            }
            HashMap<String, String> resultMaps = new HashMap<String, String>();
            ((List)List.class.cast(members)).stream().filter(Map.class::isInstance).forEach(obj -> {
                Map map = (Map)Map.class.cast(obj);
                resultMaps.put(String.valueOf(map.get("UserName")), String.valueOf(map.get("Id")));
            });
            log.info("query all users, {}.", resultMaps);
            return resultMaps;
        }
        catch (IOException e) {
            log.error("query all user failed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private boolean addUser(BmcHttpClient client, String userId, String userPwd) {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("Id", userId);
        maps.put("UserName", USER_NAME);
        maps.put("Password", userPwd);
        maps.put("RoleId", "Administrator");
        try {
            log.info("add ibmc user, username : {}, id : {}.", (Object)USER_NAME, (Object)userId);
            return client.execute((header, api) -> api.createUser(header, maps)).isSuccessful();
        }
        catch (IOException e) {
            log.info("add user failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    protected List<ManageDevice> toManageDevice() {
        return CollectionUtils.emptyIfNull(this.serverInfos).stream().map(ServerInfo::toManageDevice).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Generated
    protected ServerTakeoverTask(ServerTakeoverTaskBuilder<?, ?> b) {
        super(b);
        this.serverInfos = ((ServerTakeoverTaskBuilder)b).serverInfos;
    }

    @Generated
    public static ServerTakeoverTaskBuilder<?, ?> builder() {
        return new ServerTakeoverTaskBuilderImpl();
    }

    @Generated
    private static final class ServerTakeoverTaskBuilderImpl
    extends ServerTakeoverTaskBuilder<ServerTakeoverTask, ServerTakeoverTaskBuilderImpl> {
        @Generated
        private ServerTakeoverTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ServerTakeoverTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ServerTakeoverTask build() {
            return new ServerTakeoverTask(this);
        }
    }

    @Generated
    public static abstract class ServerTakeoverTaskBuilder<C extends ServerTakeoverTask, B extends ServerTakeoverTaskBuilder<C, B>>
    extends TakeoverBaseTask.TakeoverBaseTaskBuilder<C, B> {
        @Generated
        private List<ServerInfo> serverInfos;

        @Generated
        public B serverInfos(List<ServerInfo> serverInfos) {
            this.serverInfos = serverInfos;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ServerTakeoverTask.ServerTakeoverTaskBuilder(super=" + super.toString() + ", serverInfos=" + this.serverInfos + ")";
        }
    }
}

