/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.FusionCubeReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.ManageDevice;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MetaVisionInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.TakeoverTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.TaskDetailInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverError;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TakeoverBaseTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TakeoverBaseTask.class);
    private MetaVisionInfo metaVisionInfo;

    public void execute() throws TaskException {
        FusionCubeReqClient fusionCubeReqClient = new FusionCubeReqClient(this.metaVisionInfo);
        try {
            log.info("start to login...");
            if (!fusionCubeReqClient.login()) {
                throw new TakeoverException(TakeoverError.LOGIN_MV_FAILED);
            }
            log.info("prepare to handle takeover.");
            this.preTakeoverDevice(fusionCubeReqClient);
            List<ManageDevice> manageDevices = this.toManageDevice();
            manageDevices = this.tryToFilterManagedDevices(fusionCubeReqClient, manageDevices);
            if (CollectionUtils.isEmpty(manageDevices)) {
                log.info("all device has managed to MetaVision.");
                return;
            }
            log.info("start to manage device..., size : {}.", (Object)manageDevices.size());
            Optional<String> result = fusionCubeReqClient.manageDevice(manageDevices);
            log.info("manage device result : {}.", result);
            if (!result.isPresent()) {
                throw new TakeoverException(this.buildDefaultTakeoverError());
            }
            RetryUtils.retry(() -> fusionCubeReqClient.queryManageDeviceResult((String)result.get()), this::checkTaskFinished, (int)10, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (FcTaskException e) {
            log.error("timeout to query takeover task.", (Throwable)e);
            throw new TakeoverException(TakeoverError.QUERY_MANAGE_RESULT_TIMEOUT);
        }
        finally {
            fusionCubeReqClient.logout();
        }
    }

    private void parseQueryDeviceType(List<ManageDevice> manageDevices, Set<String> deviceTypes) {
        manageDevices.forEach(device -> {
            Optional.ofNullable(device.getDeviceType()).filter(StringUtils::isNotEmpty).ifPresent(deviceTypes::add);
            if (CollectionUtils.isNotEmpty(device.getChildDevices())) {
                this.parseQueryDeviceType(device.getChildDevices(), deviceTypes);
            }
        });
    }

    private List<ManageDevice> tryToFilterManagedDevices(FusionCubeReqClient fusionCubeReqClient, List<ManageDevice> manageDevices) {
        HashSet<String> deviceTypes = new HashSet<String>();
        this.parseQueryDeviceType(manageDevices, deviceTypes);
        log.info("try to filter managed device, types : {}.", deviceTypes);
        Set deviceNames = fusionCubeReqClient.queryManageDevices(deviceTypes).stream().map(ManageDevice::getDeviceName).collect(Collectors.toSet());
        log.info("try to filter managed device, exist deviceNames : {}.", deviceNames);
        return manageDevices.stream().filter(device -> !deviceNames.contains(device.getDeviceName())).collect(Collectors.toList());
    }

    protected void preTakeoverDevice(FusionCubeReqClient fusionCubeReqClient) {
        log.info("pre takeover do nothing.");
    }

    protected TakeoverError buildDefaultTakeoverError() {
        return TakeoverError.MANAGE_DEVICE_FAILED;
    }

    private boolean checkTaskFinished(Optional<TaskDetailInfo> detailInfo) {
        if (!detailInfo.isPresent()) {
            return false;
        }
        TaskDetailInfo taskDetailInfo = detailInfo.get();
        TakeoverTaskStatus taskStatus = TakeoverTaskStatus.of(taskDetailInfo.getStatus());
        if (taskStatus.isSuccess()) {
            log.info("manage device success, id : {}.", detailInfo);
            return true;
        }
        if (taskStatus.isFailed()) {
            log.error("manage device failed, timeout, id : {}.", detailInfo);
            throw new TakeoverException(this.buildDefaultTakeoverError());
        }
        if (taskStatus.isCancelled()) {
            log.error("manage device cancelled, id : {}.", detailInfo);
            throw new TakeoverException(TakeoverError.MANAGE_DEVICE_CANCELLED);
        }
        return false;
    }

    protected abstract List<ManageDevice> toManageDevice();

    @Generated
    protected TakeoverBaseTask(TakeoverBaseTaskBuilder<?, ?> b) {
        super(b);
        this.metaVisionInfo = ((TakeoverBaseTaskBuilder)b).metaVisionInfo;
    }

    @Generated
    public static abstract class TakeoverBaseTaskBuilder<C extends TakeoverBaseTask, B extends TakeoverBaseTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private MetaVisionInfo metaVisionInfo;

        @Generated
        public B metaVisionInfo(MetaVisionInfo metaVisionInfo) {
            this.metaVisionInfo = metaVisionInfo;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TakeoverBaseTask.TakeoverBaseTaskBuilder(super=" + super.toString() + ", metaVisionInfo=" + this.metaVisionInfo + ")";
        }
    }
}

