/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.entity;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuIpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.KmcCryptUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class NpuConfig {
    private String taskId;
    private String masterIp;
    private String username;
    private String password;
    private String orgAdminPwd;
    private String npuDriverPath;
    private String npuDriverName;
    private String npuDriverVersion;
    private String devicePluginPath;
    private List<String> devicePluginYamlPaths;
    private List<String> exporterYamlPaths;
    private String exporterPath;
    private String dockerRuntimePath;
    private String iBMAPath;
    private List<NpuIpConfig> npuIpConfigs;
    private List<NpuConfigCmd> nodeInfos;

    public void setNpuDriverPath(String npuDriverPath) {
        this.npuDriverPath = npuDriverPath;
        this.npuDriverName = this.parseDriverName();
        this.npuDriverVersion = this.parseDriverVersion();
    }

    public void setPassword(String password) {
        this.password = KmcCryptUtils.encrypt((String)password);
    }

    public String getPassword() {
        return KmcCryptUtils.decrypt((String)this.password);
    }

    public void setOrgAdminPwd(String orgAdminPwd) {
        this.orgAdminPwd = KmcCryptUtils.encrypt((String)orgAdminPwd);
    }

    public String getOrgAdminPwd() {
        return KmcCryptUtils.decrypt((String)this.orgAdminPwd);
    }

    private String parseDriverVersion() {
        return ConsistencyPattern.parseNpuDriverVersion((String)new File(this.npuDriverPath).getName());
    }

    private String parseDriverName() {
        return ConsistencyPattern.parseNpuDriverName((String)new File(this.npuDriverPath).getName());
    }

    public boolean isNeedInstallNpuDriver() {
        return this.nodeInfos.stream().anyMatch(cmd -> Arrays.asList("Ascend910B", "Ascend310P").contains(cmd.getDriverType()));
    }

    @Generated
    NpuConfig(String taskId, String masterIp, String username, String password, String orgAdminPwd, String npuDriverPath, String npuDriverName, String npuDriverVersion, String devicePluginPath, List<String> devicePluginYamlPaths, List<String> exporterYamlPaths, String exporterPath, String dockerRuntimePath, String iBMAPath, List<NpuIpConfig> npuIpConfigs, List<NpuConfigCmd> nodeInfos) {
        this.taskId = taskId;
        this.masterIp = masterIp;
        this.username = username;
        this.password = password;
        this.orgAdminPwd = orgAdminPwd;
        this.npuDriverPath = npuDriverPath;
        this.npuDriverName = npuDriverName;
        this.npuDriverVersion = npuDriverVersion;
        this.devicePluginPath = devicePluginPath;
        this.devicePluginYamlPaths = devicePluginYamlPaths;
        this.exporterYamlPaths = exporterYamlPaths;
        this.exporterPath = exporterPath;
        this.dockerRuntimePath = dockerRuntimePath;
        this.iBMAPath = iBMAPath;
        this.npuIpConfigs = npuIpConfigs;
        this.nodeInfos = nodeInfos;
    }

    @Generated
    public static NpuConfigBuilder builder() {
        return new NpuConfigBuilder();
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getMasterIp() {
        return this.masterIp;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getNpuDriverPath() {
        return this.npuDriverPath;
    }

    @Generated
    public String getNpuDriverName() {
        return this.npuDriverName;
    }

    @Generated
    public String getNpuDriverVersion() {
        return this.npuDriverVersion;
    }

    @Generated
    public String getDevicePluginPath() {
        return this.devicePluginPath;
    }

    @Generated
    public List<String> getDevicePluginYamlPaths() {
        return this.devicePluginYamlPaths;
    }

    @Generated
    public List<String> getExporterYamlPaths() {
        return this.exporterYamlPaths;
    }

    @Generated
    public String getExporterPath() {
        return this.exporterPath;
    }

    @Generated
    public String getDockerRuntimePath() {
        return this.dockerRuntimePath;
    }

    @Generated
    public String getIBMAPath() {
        return this.iBMAPath;
    }

    @Generated
    public List<NpuIpConfig> getNpuIpConfigs() {
        return this.npuIpConfigs;
    }

    @Generated
    public List<NpuConfigCmd> getNodeInfos() {
        return this.nodeInfos;
    }

    @Generated
    public static class NpuConfigBuilder {
        @Generated
        private String taskId;
        @Generated
        private String masterIp;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String orgAdminPwd;
        @Generated
        private String npuDriverPath;
        @Generated
        private String npuDriverName;
        @Generated
        private String npuDriverVersion;
        @Generated
        private String devicePluginPath;
        @Generated
        private List<String> devicePluginYamlPaths;
        @Generated
        private List<String> exporterYamlPaths;
        @Generated
        private String exporterPath;
        @Generated
        private String dockerRuntimePath;
        @Generated
        private String iBMAPath;
        @Generated
        private List<NpuIpConfig> npuIpConfigs;
        @Generated
        private List<NpuConfigCmd> nodeInfos;

        @Generated
        NpuConfigBuilder() {
        }

        @Generated
        public NpuConfigBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public NpuConfigBuilder masterIp(String masterIp) {
            this.masterIp = masterIp;
            return this;
        }

        @Generated
        public NpuConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public NpuConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public NpuConfigBuilder orgAdminPwd(String orgAdminPwd) {
            this.orgAdminPwd = orgAdminPwd;
            return this;
        }

        @Generated
        public NpuConfigBuilder npuDriverPath(String npuDriverPath) {
            this.npuDriverPath = npuDriverPath;
            return this;
        }

        @Generated
        public NpuConfigBuilder npuDriverName(String npuDriverName) {
            this.npuDriverName = npuDriverName;
            return this;
        }

        @Generated
        public NpuConfigBuilder npuDriverVersion(String npuDriverVersion) {
            this.npuDriverVersion = npuDriverVersion;
            return this;
        }

        @Generated
        public NpuConfigBuilder devicePluginPath(String devicePluginPath) {
            this.devicePluginPath = devicePluginPath;
            return this;
        }

        @Generated
        public NpuConfigBuilder devicePluginYamlPaths(List<String> devicePluginYamlPaths) {
            this.devicePluginYamlPaths = devicePluginYamlPaths;
            return this;
        }

        @Generated
        public NpuConfigBuilder exporterYamlPaths(List<String> exporterYamlPaths) {
            this.exporterYamlPaths = exporterYamlPaths;
            return this;
        }

        @Generated
        public NpuConfigBuilder exporterPath(String exporterPath) {
            this.exporterPath = exporterPath;
            return this;
        }

        @Generated
        public NpuConfigBuilder dockerRuntimePath(String dockerRuntimePath) {
            this.dockerRuntimePath = dockerRuntimePath;
            return this;
        }

        @Generated
        public NpuConfigBuilder iBMAPath(String iBMAPath) {
            this.iBMAPath = iBMAPath;
            return this;
        }

        @Generated
        public NpuConfigBuilder npuIpConfigs(List<NpuIpConfig> npuIpConfigs) {
            this.npuIpConfigs = npuIpConfigs;
            return this;
        }

        @Generated
        public NpuConfigBuilder nodeInfos(List<NpuConfigCmd> nodeInfos) {
            this.nodeInfos = nodeInfos;
            return this;
        }

        @Generated
        public NpuConfig build() {
            return new NpuConfig(this.taskId, this.masterIp, this.username, this.password, this.orgAdminPwd, this.npuDriverPath, this.npuDriverName, this.npuDriverVersion, this.devicePluginPath, this.devicePluginYamlPaths, this.exporterYamlPaths, this.exporterPath, this.dockerRuntimePath, this.iBMAPath, this.npuIpConfigs, this.nodeInfos);
        }

        @Generated
        public String toString() {
            return "NpuConfig.NpuConfigBuilder(taskId=" + this.taskId + ", masterIp=" + this.masterIp + ", username=" + this.username + ", password=" + this.password + ", orgAdminPwd=" + this.orgAdminPwd + ", npuDriverPath=" + this.npuDriverPath + ", npuDriverName=" + this.npuDriverName + ", npuDriverVersion=" + this.npuDriverVersion + ", devicePluginPath=" + this.devicePluginPath + ", devicePluginYamlPaths=" + this.devicePluginYamlPaths + ", exporterYamlPaths=" + this.exporterYamlPaths + ", exporterPath=" + this.exporterPath + ", dockerRuntimePath=" + this.dockerRuntimePath + ", iBMAPath=" + this.iBMAPath + ", npuIpConfigs=" + this.npuIpConfigs + ", nodeInfos=" + this.nodeInfos + ")";
        }
    }
}

