/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.http;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.google.gson.JsonSyntaxException;
import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRetryInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.ClusterResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.ContentResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.DriverInstallRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.DriverInstallResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.InitializeFileUploadRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.InitializeFileUploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.InstallationPackageInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.LoginResultVo;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.LoginVo;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.ModifyPwdRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.ModifyPwdVo;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NamespaceResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NodeResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerBaseClient;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcontainerApiClientImpl
extends EcontainerBaseClient
implements EcontainerApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EcontainerApiClientImpl.class);
    private static final String AUTH_HEADER = "X-Auth-Token";
    private final NpuConfig config;
    private final EcontainerRequestApi requestApi;
    private final Map<String, String> defaultHeader = new HashMap<String, String>();
    private String authToken;

    public EcontainerApiClientImpl(NpuConfig config) {
        this.config = config;
        this.requestApi = (EcontainerRequestApi)HttpRequestApiFactory.createRequestApi((String)("https://" + config.getMasterIp()), EcontainerRequestApi.class, (Duration)Duration.ofMinutes(5L), (Interceptor[])new Interceptor[]{chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            if (response.isSuccessful() && response.code() == 401) {
                log.info("The authentication has expired, try to reLogin.");
                response.close();
                this.initSession();
                this.updateToken(request, this.authToken);
                return chain.proceed(request);
            }
            return response;
        }, HttpRetryInterceptor.builder().build()});
        this.waitMetaVersionStart();
        this.retry5Times(this::initSession);
    }

    private void waitMetaVersionStart() {
        int count = 0;
        while (true) {
            if (count >= 60) {
                throw new NpuException(NpuError.REQUEST_FAILED);
            }
            try {
                retrofit2.Response response = this.requestApi.checkHealth().execute();
                if (response.isSuccessful()) {
                    ThreadUtils.threadSafeSleep((int)60, (TimeUnit)TimeUnit.SECONDS);
                    break;
                }
            }
            catch (IOException e) {
                log.info("check MetaVersion healthy failed");
            }
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            ++count;
        }
    }

    private Request updateToken(Request request, String token) {
        Request.Builder builder = request.newBuilder();
        builder.removeHeader(AUTH_HEADER);
        builder.addHeader(AUTH_HEADER, token);
        return builder.build();
    }

    @Override
    public void uploadDriver(InstallationPackageInfo packageInfo) {
        try {
            log.info("start to upload file:{}", (Object)packageInfo.getFileName());
            InitializeFileUploadResponse response = this.initializeFileUpload(packageInfo);
            this.uploadSliceFile(packageInfo.getFile(), response);
            this.execute((Query<Void>)((Query)() -> this.requestApi.mergeSliceFile(this.defaultHeader, response.getFileId())));
            log.info("finished upload file:{}", (Object)packageInfo.getFileName());
        }
        catch (NpuException e) {
            if ("13020003".equals(e.getErrorCode())) {
                log.info("Duplicate resource: {}. Skip uploading this file.", (Object)packageInfo.getFileName());
                return;
            }
            throw e;
        }
    }

    private void uploadSliceFile(File file, InitializeFileUploadResponse response) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            int startIndex = 0;
            for (int i = 0; i < response.getTotalSliceNum(); ++i) {
                int slice = this.getSlice(response, i);
                RequestBody body = this.getSliceRequestBody(file, inputStream, slice, i + 1, startIndex);
                this.execute((Query<Void>)((Query)() -> this.requestApi.uploadSliceFile(this.defaultHeader, response.getFileId(), body)));
                startIndex += slice;
            }
        }
        catch (IOException exception) {
            log.error("failed to upload slice file:{}", (Object)file.getName(), (Object)exception);
            throw new NpuException(NpuError.UPLOAD_IMAGE_SLICE_FAILED);
        }
    }

    private InitializeFileUploadResponse initializeFileUpload(InstallationPackageInfo packageInfo) {
        return (InitializeFileUploadResponse)this.query(() -> this.requestApi.initializeUpload(this.defaultHeader, new InitializeFileUploadRequest().setBusinessId(packageInfo.getBusinessId()).setFileName(packageInfo.getFileName()).setFileSize(packageInfo.getSize()).setFileType(packageInfo.getFileType()).setSource(packageInfo.getSource())));
    }

    private int getSlice(InitializeFileUploadResponse response, int batch) {
        return response.getFileSize() < response.getSingleSliceSize() ? response.getFileSize() : Math.min(response.getFileSize() - batch * response.getSingleSliceSize(), response.getSingleSliceSize());
    }

    private RequestBody getSliceRequestBody(File file, FileInputStream inputStream, int slice, int order, int startIndex) throws IOException {
        byte[] bytes = new byte[slice];
        inputStream.read(bytes);
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("jsonString", EcontainerApiClientImpl.getSliceJson(bytes, startIndex, order)).addFormDataPart("sliceFile", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])bytes)).build();
    }

    private static String getSliceJson(byte[] bytes, int startIndex, int order) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("order", order);
        jsonMap.put("rangeStart", startIndex);
        jsonMap.put("rangeEnd", startIndex + bytes.length);
        jsonMap.put("sliceCheckCode", DigestUtils.sha256Hex((byte[])bytes));
        return JSON.toJSONString(jsonMap);
    }

    @Override
    public List<String> installDriver(List<NpuConfigCmd> commands) {
        String clusterId = ((ClusterResponse)this.queryList(() -> this.requestApi.queryClusterInfo(this.defaultHeader)).get(0)).getClusterId();
        Map<String, String> nodeIpMap = this.queryList(() -> this.requestApi.queryNodeInfo(this.defaultHeader, clusterId)).stream().collect(Collectors.toMap(NodeResponse::getManageAddress, NodeResponse::getId));
        log.info("node info:{}", nodeIpMap);
        List contentResponses = (List)this.query(() -> this.requestApi.queryBusinessId(this.defaultHeader));
        if (CollectionUtils.isEmpty((Collection)contentResponses)) {
            log.warn("failed to query business Id");
            throw new NpuException(NpuError.DATA_ERROR);
        }
        String businessId = ((ContentResponse)contentResponses.get(0)).getId();
        commands.forEach(cmd -> this.uploadDriver(this.buildInstallationPackageInfo((NpuConfigCmd)cmd, businessId)));
        return commands.stream().map(cmd -> this.installSingleNodeDriver(new DriverInstallRequest(cmd.getNpuDriverName(), cmd.getNpuDriverVersion()), clusterId, (String)nodeIpMap.get(cmd.getIp()))).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private InstallationPackageInfo buildInstallationPackageInfo(NpuConfigCmd cmd, String businessId) {
        File file = new File(cmd.getNpuDriverPath());
        if (!file.exists()) {
            log.error("software not existed:{}", (Object)cmd.getNpuDriverPath());
            throw new NpuException(NpuError.DATA_ERROR);
        }
        return new InstallationPackageInfo().setFile(file).setSize(file.length()).setFileName(file.getName()).setFileType("zip").setSource("driver").setBusinessId(businessId);
    }

    private String installSingleNodeDriver(DriverInstallRequest driverInstallRequest, String clusterId, String nodeId) {
        try {
            log.info("start install driver:[{}], clusterId:{}, nodeId:{}", new Object[]{driverInstallRequest, clusterId, nodeId});
            return this.query(() -> this.requestApi.installDriver(this.defaultHeader, clusterId, nodeId, driverInstallRequest), DriverInstallResponse::getTaskId);
        }
        catch (NpuException e) {
            if ("13010439".equals(e.getErrorCode())) {
                log.info("driver:{} already installed", (Object)driverInstallRequest.getDriverName());
                return "";
            }
            throw e;
        }
    }

    private void uploadDevicePlugin(File file) {
        List namespaces = this.queryList(() -> this.requestApi.queryNamespaceId(this.defaultHeader));
        if (CollectionUtils.isEmpty(namespaces)) {
            log.error("failed to query image namespace");
            throw new NpuException(NpuError.DATA_ERROR);
        }
        String namespaceId = ((NamespaceResponse)namespaces.get(0)).getId();
        log.info("upload device plugin namespace id : {}.", (Object)namespaceId);
        this.execute((Query<Void>)((Query)() -> this.requestApi.uploadDevicePluginAndExport(this.defaultHeader, namespaceId, this.getFileRequestBody(file))));
    }

    private RequestBody getFileRequestBody(File file) {
        byte[] bytes;
        try (FileInputStream inputStream = new FileInputStream(file);){
            bytes = new byte[(int)file.length()];
            inputStream.read(bytes);
        }
        catch (IOException exception) {
            throw new NpuException(NpuError.DATA_ERROR);
        }
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])bytes)).build();
    }

    @Override
    public void upload(File file) {
        for (int retry = 0; retry < 2; ++retry) {
            try {
                log.info("start to upload file : {}, retry : {}.", (Object)file.getName(), (Object)retry);
                this.uploadDevicePlugin(file);
                return;
            }
            catch (NpuException e) {
                log.warn("upload file failed, retry : {}, file name : {}.", new Object[]{retry, file.getName(), e});
                ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
        }
        log.info("last to try upload file : {}.", (Object)file.getName());
        this.uploadDevicePlugin(file);
    }

    @Override
    public JSONObject queryDriverTaskDetail(@NotNull String taskId) {
        return (JSONObject)this.query(() -> this.requestApi.queryTaskDetail(this.defaultHeader, taskId));
    }

    private void initSession() {
        if (!this.loginEcontainer()) {
            throw new NpuException(NpuError.LOGIN_FAILED);
        }
        this.defaultHeader.put(AUTH_HEADER, this.authToken);
    }

    private boolean loginEcontainer() {
        Optional<LoginResultVo> loginResultVo = this.tryToLogin(this.config.getUsername(), this.config.getOrgAdminPwd());
        if (!loginResultVo.isPresent()) {
            loginResultVo = this.tryToLogin(this.config.getUsername(), this.config.getPassword());
        }
        if (loginResultVo.isPresent() && loginResultVo.get().getData().isNeedChangePwd()) {
            boolean result = this.updateToken(loginResultVo.get()) && this.modifyPwd(this.config.getOrgAdminPwd(), this.config.getPassword());
            log.info("update token and modify pwd result : {}{}.", (Object)result, (Object)LogFilterMark.INSENSITIVE);
            if (result) {
                loginResultVo = this.tryToLogin(this.config.getUsername(), this.config.getPassword());
            }
        }
        return loginResultVo.isPresent() && this.updateToken(loginResultVo.get());
    }

    private Optional<LoginResultVo> tryToLogin(String username, String password) {
        try {
            retrofit2.Response response = this.requestApi.login(new LoginVo(username, password)).execute();
            if (!response.isSuccessful() || Objects.isNull(response.body()) || Objects.isNull(((LoginResultVo)response.body()).getData())) {
                log.error("login econtainer failed,current code {}", (Object)response.code());
                return Optional.empty();
            }
            return Optional.of(response.body());
        }
        catch (IOException e) {
            log.error("login econtainer failed", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean updateToken(LoginResultVo resultVo) {
        if (Objects.nonNull(resultVo.getData()) && StringUtils.isNotEmpty((CharSequence)resultVo.getData().getToken())) {
            this.authToken = resultVo.getData().getToken();
            this.defaultHeader.put(AUTH_HEADER, this.authToken);
            return true;
        }
        return false;
    }

    private boolean modifyPwd(String orgPwd, String password) {
        ModifyPwdRequest request = new ModifyPwdRequest();
        request.setOrignalPassword(orgPwd);
        request.setNewPassword(password);
        try {
            Optional<ModifyPwdVo> opPwdVo = this.parseModifyPwdResponse((retrofit2.Response<ModifyPwdVo>)this.requestApi.modifyPassword(this.defaultHeader, request).execute());
            if (!opPwdVo.isPresent()) {
                log.error("not find modify pwd response result.{}", (Object)LogFilterMark.INSENSITIVE);
                return false;
            }
            ModifyPwdVo pwdVo = opPwdVo.get();
            if (Objects.equals("0", pwdVo.getCode())) {
                log.info("modify pwd success.{}", (Object)LogFilterMark.INSENSITIVE);
                return true;
            }
            log.error("modify pwd failed. code:{}, msg:{}{}.", new Object[]{pwdVo.getCode(), pwdVo.getMsg(), LogFilterMark.INSENSITIVE});
            throw new NpuException(NpuError.MODIFY_PASSWORD_ERROR, Collections.singletonList(pwdVo.getMsg()));
        }
        catch (IOException e) {
            log.error("modify pwd failed.", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ModifyPwdVo> parseModifyPwdResponse(retrofit2.Response<ModifyPwdVo> response) {
        if (response.isSuccessful()) {
            return Optional.ofNullable(response.body());
        }
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                Optional<ModifyPwdVo> optional2 = Optional.empty();
                return optional2;
            }
            String error = errorBody.string();
            log.warn("request failed ,error is [{}]{}", (Object)error, (Object)LogFilterMark.INSENSITIVE);
            Optional<Object> optional = Optional.ofNullable(JsonUtils.toObject((String)error, ModifyPwdVo.class));
            return optional;
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("deal errorBody error", e);
            return Optional.empty();
        }
    }

    private void retry5Times(Login login) {
        int tryTime = 0;
        while (true) {
            try {
                login.executeLogin();
                return;
            }
            catch (NpuException e) {
                log.error("MetaVersion login failed, try {}", (Object)tryTime, (Object)e);
                if (tryTime++ >= 5 || Objects.equals(e.getKey(), NpuError.MODIFY_PASSWORD_ERROR.getKey())) {
                    throw e;
                }
                ThreadUtils.threadSafeSleep((int)2, (TimeUnit)TimeUnit.MINUTES);
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    private static interface Login {
        public void executeLogin() throws NpuException;
    }
}

