/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.http;

import com.google.gson.JsonSyntaxException;
import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.DataList;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.ErrorResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class EcontainerBaseClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EcontainerBaseClient.class);

    protected <T> T query(Query<T> query) {
        try {
            return (T)Optional.of(query.query().execute()).map(this::dealResponse).orElseThrow(() -> new NpuException(NpuError.DATA_ERROR));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new NpuException(NpuError.DATA_ERROR);
        }
    }

    protected <T> List<T> queryList(Query<DataList<T>> query) {
        return this.query(query, DataList::getData);
    }

    protected <T, R> R query(Query<T> query, Function<T, R> mapper) {
        try {
            return Optional.of(query.query().execute()).map(this::dealResponse).map(mapper).orElseThrow(() -> new NpuException(NpuError.DATA_ERROR));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new NpuException(NpuError.DATA_ERROR);
        }
    }

    protected void execute(Query<Void> execute) {
        try {
            this.dealResponse(execute.query().execute());
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new NpuException(NpuError.DATA_ERROR);
        }
    }

    private <T> T dealResponse(Response<T> response) {
        log.info("response:{}, body:{}", (Object)response.raw(), response.body());
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        ErrorResponse errorResponse = this.getErrorResponse(response);
        if (errorResponse == null) {
            throw new NpuException(NpuError.REQUEST_FAILED);
        }
        throw new NpuException(NpuError.TASK_FAILED, errorResponse.getErrorCode(), errorResponse.getErrorMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ErrorResponse getErrorResponse(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                ErrorResponse errorResponse2 = new ErrorResponse();
                return errorResponse2;
            }
            String error = errorBody.string();
            log.warn("request failed ,error is [{}]", (Object)error);
            ErrorResponse errorResponse = (ErrorResponse)JsonUtils.toObject((String)error, ErrorResponse.class);
            return errorResponse;
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("deal errorBody error", e);
            return new ErrorResponse();
        }
    }
}

