/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.EcontainerConfigUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuIpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallComponentTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallComponentTask.class);
    public static final String NAME_KEY = "container.component";
    private static final String CONFIG_NPU_IP_CMD = "hccn_tool -i %s -ip -s address %s netmask %s";
    private static final String CONFIG_NPU_GATEWAY_CMD = "hccn_tool -i %s -gateway -s gateway %s";
    private static final String CONFIG_NPU_NETDETECT_CMD = "hccn_tool -i %s -netdetect -s address %s";
    private final NpuConfig config;

    public void execute() throws TaskException {
        AtomicInteger index = new AtomicInteger();
        this.config.getNodeInfos().forEach(nodeInfo -> this.configDockerRuntimeAndNpuIp((NpuConfigCmd)nodeInfo, index.getAndIncrement()));
    }

    public void afterExecute() {
        super.afterExecute();
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    private void configDockerRuntimeAndNpuIp(NpuConfigCmd cmd, int index) {
        SshShellService sshClient = null;
        try {
            sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(cmd);
            this.configDockerRuntime(cmd, sshClient);
            this.installIBMA(cmd, sshClient);
            this.configNpuIp(cmd, index, sshClient);
        }
        catch (SshException e) {
            log.error("execute upload software package failed", (Throwable)e);
            throw new NpuException(NpuError.DATA_ERROR);
        }
        finally {
            SshManager.releaseConnService((SshConnService)sshClient);
        }
    }

    private void hotReset(SshShellService sshClient) throws SshException {
        log.info("execute cmd /usr/local/Ascend/driver/tools/upgrade-tool --device_index -1 --hot_reset");
        String result = sshClient.execCommandWithTimeout("/usr/local/Ascend/driver/tools/upgrade-tool --device_index -1 --hot_reset", 600);
        log.info("result is {}", (Object)result);
        if (!result.contains("hot reset success")) {
            throw new NpuException(NpuError.RESET_CHIP_FAILED);
        }
    }

    private void configDockerRuntime(NpuConfigCmd cmd, SshShellService sshClient) throws SshException {
        String dockerRuntimeFilePath = this.config.getDockerRuntimePath();
        String dockerRuntimeFileName = dockerRuntimeFilePath.substring(dockerRuntimeFilePath.lastIndexOf("\\") + 1);
        this.uploadFile(cmd, dockerRuntimeFilePath, dockerRuntimeFileName);
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format("cd %s", "/home/manageromm"));
        ExecuteSshCommandUtils.executeCommand(sshClient, "mkdir /home/install");
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format("mv %s /home/install", dockerRuntimeFileName));
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /home/install");
        ExecuteSshCommandUtils.executeCommand(sshClient, "chmod 550 " + dockerRuntimeFileName);
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format("./%s --install", dockerRuntimeFileName), false);
        ExecuteSshCommandUtils.executeCommand(sshClient, "systemctl daemon-reload && systemctl restart docker", false);
    }

    private void configNpuIp(NpuConfigCmd cmd, int index, SshShellService sshClient) throws SshException {
        if (!Objects.equals("Ascend910B", cmd.getDriverType())) {
            log.info("current server {} not need to config npu.", (Object)cmd.getDriverType());
            return;
        }
        this.hotReset(sshClient);
        this.waitNpuStart(sshClient);
        List<NpuIpConfig> npuIpConfigs = this.config.getNpuIpConfigs();
        for (int i = 0; i < npuIpConfigs.size(); ++i) {
            NpuIpConfig npuIpConfig = npuIpConfigs.get(i);
            this.configNpuIps(sshClient, npuIpConfig, i, this.getIp(npuIpConfig.getNpuStartIp(), 2 * index));
            this.configNpuIps(sshClient, npuIpConfig, i + 4, this.getIp(npuIpConfig.getNpuStartIp(), 2 * index + 1));
        }
    }

    private void configNpuIps(SshShellService sshClient, NpuIpConfig npuIpConfig, int i, String ip) throws SshException {
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format(CONFIG_NPU_IP_CMD, i, ip, npuIpConfig.getNetmask()));
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format(CONFIG_NPU_GATEWAY_CMD, i, npuIpConfig.getGateway()));
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format(CONFIG_NPU_NETDETECT_CMD, i, npuIpConfig.getGateway()));
    }

    private void waitNpuStart(SshShellService sshClient) throws SshException {
        block1: {
            long costTime;
            long startTime = System.currentTimeMillis();
            do {
                ThreadUtils.threadSafeSleep((int)30, (TimeUnit)TimeUnit.SECONDS);
                log.info("execute cmd npu-smi info");
                String npuInfo = sshClient.execCommand("npu-smi info");
                log.info("result is {}", (Object)npuInfo);
                if (StringUtils.countMatches((CharSequence)npuInfo, (CharSequence)"OK") >= EcontainerConfigUtil.getInteger("econtainer.each.npu.num", 8)) break block1;
            } while (TimeUnit.MILLISECONDS.toMinutes(costTime = System.currentTimeMillis() - startTime) < 10L);
            log.error("wait npu start over 10 min");
            throw new NpuException(NpuError.WAIT_NPU_START_FAILED);
        }
    }

    private String getIp(String ip, int index) {
        String startIp = ip.substring(0, ip.lastIndexOf(".") + 1);
        String endIp = ip.substring(ip.lastIndexOf(".") + 1);
        return startIp + (Integer.parseInt(endIp) + index * 4);
    }

    private void installIBMA(SshCmd cmd, SshShellService sshClient) throws SshException {
        String ibmaFilePath = this.config.getIBMAPath();
        String ibmaTarPath = this.unzipIbmaFile(ibmaFilePath);
        String ibmaTarName = ibmaTarPath.substring(ibmaTarPath.lastIndexOf("\\") + 1);
        this.uploadFile(cmd, ibmaTarPath, ibmaTarName);
        FileOperateUtils.deleteDirectory((String)ImageConstant.CACHE_DIR);
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format("cd %s", "/home/manageromm"));
        ExecuteSshCommandUtils.executeCommand(sshClient, "mkdir /opt/iBMA");
        ExecuteSshCommandUtils.executeCommand(sshClient, String.format("mv %s /opt/iBMA", ibmaTarName));
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /opt/iBMA");
        ExecuteSshCommandUtils.executeCommand(sshClient, "tar -xzvf " + ibmaTarName, false);
        ExecuteSshCommandUtils.executeCommand(sshClient, "cd /opt/iBMA/iBMA2.0");
        ExecuteSshCommandUtils.executeCommand(sshClient, "chmod 550 install.sh");
        ExecuteSshCommandUtils.executeCommand(sshClient, "./install.sh -s", false);
    }

    private String unzipIbmaFile(String ibmaFilePath) {
        log.info("start to unzip file {}", (Object)ibmaFilePath);
        String iBMAPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{ImageConstant.CACHE_DIR, "iBMA"});
        if (ZipUtils.decompressFileBy7Zip((String)ImageConstant.ZIP_TOOL_PATH, (String)ibmaFilePath, (String)iBMAPath)) {
            log.info("finish unzip file {}", (Object)ibmaFilePath);
            return this.getFilePath(iBMAPath, ConsistencyPattern::isA3000IBMATarPackage);
        }
        throw new NpuException(NpuError.DATA_ERROR);
    }

    private void uploadFile(SshCmd cmd, String path, String name) throws SshException {
        log.info("start upload {} file", (Object)name);
        SshSftpService sshSftpService = SshSessionKeepContext.getInstance().getSshSftpService(cmd);
        sshSftpService.upload(path, "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(name, (command, detail) -> this.appendTaskDetail((String)detail)));
        sshSftpService.disconnect();
        log.info("finish upload {} file", (Object)name);
    }

    private String getFilePath(String softwareFilePath, Predicate<String> predicate) {
        List specialFileNames = FileOperateUtils.getSpecialFileNames((File)new File(softwareFilePath), predicate);
        if (specialFileNames.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)File.separator, softwareFilePath, (CharSequence)specialFileNames.get(0));
    }

    @Generated
    protected InstallComponentTask(InstallComponentTaskBuilder<?, ?> b) {
        super(b);
        this.config = ((InstallComponentTaskBuilder)b).config;
    }

    @Generated
    public static InstallComponentTaskBuilder<?, ?> builder() {
        return new InstallComponentTaskBuilderImpl();
    }

    @Generated
    private static final class InstallComponentTaskBuilderImpl
    extends InstallComponentTaskBuilder<InstallComponentTask, InstallComponentTaskBuilderImpl> {
        @Generated
        private InstallComponentTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InstallComponentTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InstallComponentTask build() {
            return new InstallComponentTask(this);
        }
    }

    @Generated
    public static abstract class InstallComponentTaskBuilder<C extends InstallComponentTask, B extends InstallComponentTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private NpuConfig config;

        @Generated
        public B config(NpuConfig config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InstallComponentTask.InstallComponentTaskBuilder(super=" + super.toString() + ", config=" + this.config + ")";
        }
    }
}

