/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerApiClientImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallDevicePluginTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallDevicePluginTask.class);
    public static final String NAME_KEY = "npu.plugin";
    private final NpuConfig config;

    public void execute() throws TaskException {
        if (!this.config.isNeedInstallNpuDriver()) {
            this.appendTaskDetail("The Device Plugin does not need to be installed in the current scenario.");
            log.info("no need to install device plugin.");
            return;
        }
        File file = new File(this.config.getDevicePluginPath());
        if (!file.exists() || CollectionUtils.isEmpty(this.config.getDevicePluginYamlPaths())) {
            log.error("software not existed:{}", (Object)this.config.getDevicePluginPath());
            throw new NpuException(NpuError.DATA_ERROR);
        }
        this.appendTaskDetail("start to upload device plugin.");
        EcontainerApiClientImpl econtainerApiClient = new EcontainerApiClientImpl(this.config);
        econtainerApiClient.upload(file);
        this.appendTaskDetail("start to install device plugin.");
        this.configDevicePlugin(this.config.getNodeInfos().stream().filter(NpuConfigCmd::isMaster).findFirst().orElseThrow(() -> new NpuException(NpuError.DATA_ERROR)));
        this.appendTaskDetail("finish to install device plugin.");
    }

    public void afterExecute() {
        super.afterExecute();
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    private void configDevicePlugin(SshCmd cmd) {
        try {
            SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(cmd);
            this.uploadDevicePluginYamlFile(cmd, sshClient);
            ExecuteSshCommandUtils.executeCommand(sshClient, String.format("cd %s", "/opt/k8s/SimbaOS"));
            for (String devicePluginYamlPath : this.config.getDevicePluginYamlPaths()) {
                ExecuteSshCommandUtils.executeCommand(sshClient, String.format("kubectl apply -f %s", devicePluginYamlPath.substring(devicePluginYamlPath.lastIndexOf("\\") + 1)));
                if (ExecuteSshCommandUtils.checkPodInstallResult(sshClient, devicePluginYamlPath)) continue;
                log.error("check device plugin pod failed, yaml path : {}.", (Object)devicePluginYamlPath);
                throw new NpuException(NpuError.DATA_CHECK_DEVICE_PLUGIN_ERROR);
            }
        }
        catch (SshException e) {
            log.error("execute upload device-plugin.yaml failed", (Throwable)e);
            throw new NpuException(NpuError.DATA_ERROR);
        }
    }

    private void uploadDevicePluginYamlFile(SshCmd cmd, SshShellService sshClient) throws SshException {
        log.info("start upload device-plugin.yaml");
        SshSftpService sshSftpService = SshSessionKeepContext.getInstance().getSshSftpService(cmd);
        for (String yamlPath : this.config.getDevicePluginYamlPaths()) {
            String fileName = yamlPath.substring(yamlPath.lastIndexOf("\\") + 1);
            sshSftpService.upload(yamlPath, "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(fileName, (command, detail) -> this.appendTaskDetail((String)detail)));
            ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.formatTxt((String)"mv %s/%s %s", (Object[])new Object[]{"/home/manageromm", fileName, "/opt/k8s/SimbaOS"}));
        }
        log.info("finish upload device-plugin.yaml");
    }

    @Generated
    protected InstallDevicePluginTask(InstallDevicePluginTaskBuilder<?, ?> b) {
        super(b);
        this.config = ((InstallDevicePluginTaskBuilder)b).config;
    }

    @Generated
    public static InstallDevicePluginTaskBuilder<?, ?> builder() {
        return new InstallDevicePluginTaskBuilderImpl();
    }

    @Generated
    private static final class InstallDevicePluginTaskBuilderImpl
    extends InstallDevicePluginTaskBuilder<InstallDevicePluginTask, InstallDevicePluginTaskBuilderImpl> {
        @Generated
        private InstallDevicePluginTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InstallDevicePluginTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InstallDevicePluginTask build() {
            return new InstallDevicePluginTask(this);
        }
    }

    @Generated
    public static abstract class InstallDevicePluginTaskBuilder<C extends InstallDevicePluginTask, B extends InstallDevicePluginTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private NpuConfig config;

        @Generated
        public B config(NpuConfig config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InstallDevicePluginTask.InstallDevicePluginTaskBuilder(super=" + super.toString() + ", config=" + this.config + ")";
        }
    }
}

