/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.ssh.SshSessionKeepContext;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.utils.ExecuteSshCommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerApiClientImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallExportTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallExportTask.class);
    public static final String NAME_KEY = "npu.export";
    private final NpuConfig config;

    public void execute() throws TaskException {
        if (!this.config.isNeedInstallNpuDriver()) {
            this.appendTaskDetail("The NPU Exporter does not need to be installed in the current scenario.");
            log.info("no need to install npu exporter.");
            return;
        }
        File file = new File(this.config.getExporterPath());
        if (!file.exists() || CollectionUtils.isEmpty(this.config.getExporterYamlPaths())) {
            log.error("software not existed:{}", (Object)this.config.getExporterPath());
            throw new NpuException(NpuError.DATA_ERROR);
        }
        this.appendTaskDetail("start to upload npu exporter.");
        EcontainerApiClientImpl econtainerApiClient = new EcontainerApiClientImpl(this.config);
        econtainerApiClient.upload(file);
        this.appendTaskDetail("start to install npu exporter.");
        this.configDevicePlugin(this.config.getNodeInfos().stream().filter(NpuConfigCmd::isMaster).findFirst().orElseThrow(() -> new NpuException(NpuError.DATA_ERROR)));
        this.appendTaskDetail("finish to install npu exporter.");
    }

    public void afterExecute() {
        super.afterExecute();
        SshSessionKeepContext.getInstance().releaseSshAndSftpService();
    }

    private void configDevicePlugin(SshCmd cmd) {
        try {
            SshShellService sshClient = SshSessionKeepContext.getInstance().getSshClientOfRoot(cmd);
            this.uploadYamlFile(cmd, sshClient);
            ExecuteSshCommandUtils.executeCommand(sshClient, String.format("cd %s", "/opt/k8s/SimbaOS"));
            for (String exporterYamlPath : this.config.getExporterYamlPaths()) {
                ExecuteSshCommandUtils.executeCommand(sshClient, String.format("kubectl apply -f %s", exporterYamlPath.substring(exporterYamlPath.lastIndexOf("\\") + 1)));
                if (ExecuteSshCommandUtils.checkPodInstallResult(sshClient, exporterYamlPath)) continue;
                log.error("check npu-exporter pod failed, yaml path : {}.", (Object)exporterYamlPath);
                throw new NpuException(NpuError.DATA_CHECK_EXPORTER_ERROR);
            }
        }
        catch (SshException e) {
            log.error("execute upload npu-exporter.yaml failed", (Throwable)e);
            throw new NpuException(NpuError.DATA_ERROR);
        }
    }

    private void uploadYamlFile(SshCmd cmd, SshShellService sshClient) throws SshException {
        log.info("start upload npu-exporter.yaml");
        SshSftpService sshSftpService = SshSessionKeepContext.getInstance().getSshSftpService(cmd);
        for (String yamlPath : this.config.getExporterYamlPaths()) {
            String fileName = yamlPath.substring(yamlPath.lastIndexOf("\\") + 1);
            sshSftpService.upload(yamlPath, "/home/manageromm", (SftpProgCallback)new UploadFileProgCallBack(fileName, (command, detail) -> this.appendTaskDetail((String)detail)));
            ExecuteSshCommandUtils.executeCommand(sshClient, StringUtils.formatTxt((String)"mv %s/%s %s", (Object[])new Object[]{"/home/manageromm", fileName, "/opt/k8s/SimbaOS"}));
        }
        log.info("finish upload npu-exporter.yaml");
    }

    @Generated
    protected InstallExportTask(InstallExportTaskBuilder<?, ?> b) {
        super(b);
        this.config = ((InstallExportTaskBuilder)b).config;
    }

    @Generated
    public static InstallExportTaskBuilder<?, ?> builder() {
        return new InstallExportTaskBuilderImpl();
    }

    @Generated
    private static final class InstallExportTaskBuilderImpl
    extends InstallExportTaskBuilder<InstallExportTask, InstallExportTaskBuilderImpl> {
        @Generated
        private InstallExportTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InstallExportTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InstallExportTask build() {
            return new InstallExportTask(this);
        }
    }

    @Generated
    public static abstract class InstallExportTaskBuilder<C extends InstallExportTask, B extends InstallExportTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private NpuConfig config;

        @Generated
        public B config(NpuConfig config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InstallExportTask.InstallExportTaskBuilder(super=" + super.toString() + ", config=" + this.config + ")";
        }
    }
}

