/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask;

import com.alibaba.fastjson2.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuError;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.http.EcontainerApiClientImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallNpuDriverTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallNpuDriverTask.class);
    public static final String NAME_KEY = "npu.driver";
    public static final String TASK_SUCCESS_STATUS = "success";
    public static final String TASK_FAILED_STATUS = "failed";
    private final NpuConfig config;

    public void execute() throws TaskException {
        if (!this.config.isNeedInstallNpuDriver()) {
            this.appendTaskDetail("The NPU driver does not need to be installed in the current scenario.");
            log.info("no need to install npu driver.");
            return;
        }
        this.appendTaskDetail("start to install npu driver.");
        EcontainerApiClientImpl containerApiClient = new EcontainerApiClientImpl(this.config);
        List<String> taskIds = containerApiClient.installDriver(this.config.getNodeInfos());
        this.appendTaskDetail("wait for install npu driver task finish.");
        this.waitAllNodesFinished(containerApiClient, taskIds);
        this.appendTaskDetail("install npu driver task has finished.");
    }

    private void waitAllNodesFinished(EcontainerApiClientImpl containerApiClient, List<String> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            log.warn("driver already installed, skip....");
            return;
        }
        int failedCnt = 0;
        while (true) {
            boolean isAllReady;
            block4: {
                isAllReady = false;
                try {
                    List<JSONObject> tasks = taskIds.stream().map(containerApiClient::queryDriverTaskDetail).map(json -> json.getJSONObject("task")).collect(Collectors.toList());
                    this.checkAnyTaskFailed(tasks);
                    isAllReady = tasks.stream().allMatch(task -> task.getDouble("progress") == 1.0 && TASK_SUCCESS_STATUS.equals(task.getString("status")));
                    failedCnt = 0;
                }
                catch (NpuException e) {
                    log.error("failed to query npu driver installation task, failed cnt : {}.", (Object)failedCnt, (Object)e);
                    if (++failedCnt < 3) break block4;
                    throw e;
                }
            }
            if (isAllReady) break;
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private void checkAnyTaskFailed(List<JSONObject> tasks) {
        Optional<JSONObject> failedTask = tasks.stream().filter(task -> TASK_FAILED_STATUS.equals(task.getString("status"))).findFirst();
        if (failedTask.isPresent()) {
            log.error("npu driver installing task failed:{}", (Object)failedTask.get());
            throw new NpuException(NpuError.NPU_DRIVER_INSTALL_TASK_FAILED, "", failedTask.get().getString("desc"));
        }
    }

    @Generated
    protected InstallNpuDriverTask(InstallNpuDriverTaskBuilder<?, ?> b) {
        super(b);
        this.config = ((InstallNpuDriverTaskBuilder)b).config;
    }

    @Generated
    public static InstallNpuDriverTaskBuilder<?, ?> builder() {
        return new InstallNpuDriverTaskBuilderImpl();
    }

    @Generated
    private static final class InstallNpuDriverTaskBuilderImpl
    extends InstallNpuDriverTaskBuilder<InstallNpuDriverTask, InstallNpuDriverTaskBuilderImpl> {
        @Generated
        private InstallNpuDriverTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InstallNpuDriverTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InstallNpuDriverTask build() {
            return new InstallNpuDriverTask(this);
        }
    }

    @Generated
    public static abstract class InstallNpuDriverTaskBuilder<C extends InstallNpuDriverTask, B extends InstallNpuDriverTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private NpuConfig config;

        @Generated
        public B config(NpuConfig config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InstallNpuDriverTask.InstallNpuDriverTaskBuilder(super=" + super.toString() + ", config=" + this.config + ")";
        }
    }
}

