/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.rest;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.CommResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.LoginData;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.LoginResult;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageRequestInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class StorageReqClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageReqClient.class);
    private final LoginData loginData = new LoginData();
    private String token;
    private String cookie;
    private final StorageRequestApi requestApi;

    public StorageReqClient(String ip, String username, String password) {
        this.loginData.setUsername(username).setPassword(password).setScope("0");
        String url = StringUtils.formatTxt((String)"https://%s:8088", (Object[])new Object[]{ip});
        this.requestApi = (StorageRequestApi)HttpRequestApiFactory.createRequestApi((String)url, StorageRequestApi.class, (Interceptor[])new Interceptor[]{new StorageRequestInterceptor(ip)});
    }

    protected <T> CommResponse<T> query(Query<CommResponse<T>> query) {
        try {
            return Optional.of(query.query().execute()).map(this::dealResponse).orElseThrow(FcTaskException.thr((ErrorKey)ApiError.DATA_ERROR));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new FcTaskException((ErrorKey)ApiError.DATA_ERROR, new Object[]{exception.getMessage()});
        }
    }

    public <T> CommResponse<T> dealResponse(Response<CommResponse<T>> response) {
        if (response.isSuccessful()) {
            CommResponse body = (CommResponse)response.body();
            if (Objects.isNull(body) || !body.isSuccessfully()) {
                String errorDesc = this.getErrorDesc((CommResponse)response.body());
                if (StringUtils.isEmpty((CharSequence)errorDesc)) {
                    throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
                }
                throw new DeployException(StorageDeployError.SEND_REQ_RESPONSE_ONLY_FAIL, Collections.singletonList(errorDesc));
            }
            return body;
        }
        throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
    }

    private <T> String getErrorDesc(CommResponse<T> body) {
        if (Objects.isNull(body)) {
            return "";
        }
        return body.getErrorDesc();
    }

    public Object queryEthPort(String esn) {
        return this.query(() -> this.requestApi.queryEthPort(this.buildHeaders(), esn)).getData();
    }

    public Object modifyManagerIp(String esn, String ethId, Map<String, Object> param) {
        return this.query(() -> this.requestApi.modifyManagerIp(this.buildHeaders(), esn, ethId, param)).getData();
    }

    public boolean uploadLicense(String esn, @NotNull File licenseFile) {
        try {
            return this.requestApi.uploadLicense(this.buildHeaders(), esn, MultipartBody.Part.createFormData((String)"file", (String)licenseFile.getName(), (RequestBody)RequestBody.create((File)licenseFile, (MediaType)MediaType.parse((String)"application/octet-stream")))).execute().isSuccessful();
        }
        catch (IOException ioException) {
            log.error("logout failed.", (Throwable)ioException);
            return false;
        }
    }

    public Object queryLicenseUploadStatus(String esn) {
        return this.query(() -> this.requestApi.queryLicenseUploadStatus(this.buildHeaders(), esn)).getData();
    }

    public Object activateLicense(String esn) {
        return this.query(() -> this.requestApi.activateLicense(this.buildHeaders(), esn)).getData();
    }

    public Object createBondPort(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.createBondPort(this.buildHeaders(), esn, param)).getData();
    }

    public Object createLogicPort(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.createLogicPort(this.buildHeaders(), esn, param)).getData();
    }

    public Object createVlan(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.createVlan(this.buildHeaders(), esn, param)).getData();
    }

    public Object createFailoverGroup(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.createFailoverGroup(this.buildHeaders(), esn, param)).getData();
    }

    public Object associateFailoverGroup(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.associateFailoverGroup(this.buildHeaders(), esn, param)).getData();
    }

    public Object queryStoragePool(String esn) {
        return this.query(() -> this.requestApi.queryStoragePool(this.buildHeaders(), esn)).getData();
    }

    public Object createStoragePool(Map<String, Object> param) {
        return this.query(() -> this.requestApi.createStoragePool(this.buildHeaders(), param)).getData();
    }

    public Object queryStoragePoolTask(String taskId) {
        return this.query(() -> this.requestApi.queryStoragePoolTask(this.buildHeaders(), taskId)).getData();
    }

    public Object queryStoragePoolTaskSteps(String taskId) {
        return this.query(() -> this.requestApi.queryStoragePoolTaskSteps(this.buildHeaders(), taskId)).getData();
    }

    public Object createFileResources(String fileResource) {
        return this.query(() -> this.requestApi.createFileResources(this.buildHeaders(), fileResource)).getData();
    }

    public Object createUser(String esn, Map<String, Object> param) {
        return this.query(() -> this.requestApi.createUser(this.buildHeaders(), esn, param)).getData();
    }

    private Map<String, String> buildUploadLicenseHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Language", LanguageUtils.getCurrentLanguage().name().toLowerCase(Locale.ROOT));
        headers.put("iBaseToken", this.token);
        headers.put("Cookie", StringUtils.defaultString((String)this.cookie));
        return headers;
    }

    public boolean login() {
        try {
            Response response = this.requestApi.login(this.buildLoginHeaders(), this.loginData).execute();
            Optional loginResult = this.parseResponse(response);
            if (loginResult.isPresent()) {
                this.token = ((LoginResult)loginResult.get()).getIBaseToken();
                return StringUtils.isNotEmpty((CharSequence)this.token);
            }
        }
        catch (IOException e) {
            log.error("login failed.", (Throwable)e);
        }
        throw new DeployException(StorageDeployError.LOGIN_ERROR);
    }

    public boolean logout(String esn) {
        try {
            if (StringUtils.isEmpty((CharSequence)this.token)) {
                log.warn("token is empty, not need to logout.");
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isResponseSuccessful(this.requestApi.logout(this.buildHeaders(), esn).execute());
            return bl;
        }
        catch (IOException e) {
            log.error("logout failed.", (Throwable)e);
        }
        finally {
            log.info("clear login token.");
            this.token = "";
        }
        return false;
    }

    private <T> boolean isResponseSuccessful(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            return false;
        }
        CommResponse commResponse = (CommResponse)response.body();
        return Objects.nonNull(commResponse) && commResponse.isSuccessfully();
    }

    private <T> Optional<T> parseResponse(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            return Optional.empty();
        }
        CommResponse commResponse = (CommResponse)response.body();
        this.cookie = StringUtils.defaultString((String)response.headers().get("Set-Cookie"));
        this.cookie = this.cookie.substring(0, this.cookie.indexOf(";"));
        if (Objects.nonNull(commResponse) && commResponse.isSuccessfully()) {
            return Optional.ofNullable(commResponse.getData());
        }
        return Optional.empty();
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("iBaseToken", this.token);
        headers.put("Cookie", StringUtils.defaultString((String)this.cookie));
        return headers;
    }

    private Map<String, String> buildLoginHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        return headers;
    }
}

