/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.rest;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRequestInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageRequestInterceptor.class);
    private String ip;

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        this.appendRequestHeader(request, requestBuilder);
        return Objects.requireNonNull(this.dealLoginFail(chain, requestBuilder.build()).orElse(null));
    }

    private Optional<Response> dealLoginFail(Interceptor.Chain chain, Request request) throws IOException {
        Response response = chain.proceed(request);
        if (response.isSuccessful() || response.code() != 401) {
            return Optional.of(response);
        }
        log.info("close original request");
        response.close();
        return Optional.empty();
    }

    private void appendRequestHeader(Request request, Request.Builder requestBuilder) {
        requestBuilder.addHeader("Content-Length", this.parseContentLength(request));
        requestBuilder.addHeader("Content-Type", "application/json; charset=UTF-8");
        requestBuilder.addHeader("Accept", "application/json");
        requestBuilder.addHeader("Accept-Language", LanguageUtils.getCurrentLanguage().name().toLowerCase(Locale.ROOT));
        requestBuilder.addHeader("Host", this.ip + ":8088");
    }

    private String parseContentLength(Request request) {
        return Optional.ofNullable(request.body()).map(body -> {
            try {
                return body.contentLength();
            }
            catch (IOException e) {
                return 0L;
            }
        }).map(String::valueOf).orElse("0");
    }

    @Generated
    public StorageRequestInterceptor(String ip) {
        this.ip = ip;
    }
}

