/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.task.StorageTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueryStorageTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseQueryStorageTask.class);
    private static final int RETRY_TIMES = 60;
    protected final DeviceConfig deviceConfig;
    protected StorageReqClient storageReqClient;

    protected void queryTask(Object responseInfo) throws DeployException {
        this.queryTaskIsSuccess(this.getReqSuccessDataField(responseInfo, "taskId"));
    }

    private void queryTaskIsSuccess(String taskId) throws DeployException {
        log.info("query task {} status", (Object)taskId);
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new DeployException(StorageDeployError.TASK_ID_NOT_FOUND_ERROR);
        }
        String taskStatus = "";
        for (int count = 0; count < 60; ++count) {
            taskStatus = this.queryTaskStatus(taskId);
            log.info("task {} status is {}", (Object)taskId, (Object)taskStatus);
            if (StorageTaskStatus.isTaskRunning(taskStatus)) {
                ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            if (StorageTaskStatus.isTaskSuccessfully(taskStatus)) {
                log.info("query task {} successfully.", (Object)taskId);
                return;
            }
            this.queryFailStepDetail(taskId);
        }
        if (!StorageTaskStatus.isTaskSuccessfully(taskStatus)) {
            throw new DeployException(StorageDeployError.TASK_QUERY_TIME_OUT, Collections.singletonList(taskId));
        }
    }

    private void queryFailStepDetail(String taskId) throws DeployException {
        Object result = this.storageReqClient.queryStoragePoolTaskSteps(taskId);
        JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)result));
        for (int index = 0; index < data.size(); ++index) {
            JSONObject stepDetail = data.getJSONObject(index);
            JSONObject description = stepDetail.getJSONObject("description");
            String failReason = description.getString("description");
            String suggestion = description.getString("suggestion");
            if (!StringUtils.isNotEmpty((CharSequence)failReason)) continue;
            throw new DeployException(StorageDeployError.SEND_REQ_RESPONSE_ERROR, Collections.singletonList(failReason), Collections.singletonList(suggestion));
        }
    }

    private String queryTaskStatus(String taskId) throws DeployException {
        return this.getReqSuccessDataField(this.storageReqClient.queryStoragePoolTask(taskId), "taskStatus");
    }

    protected String getReqSuccessDataField(Object response, String needField) throws DeployException {
        return JSON.parseObject((String)JSON.toJSONString((Object)response)).getString(needField);
    }

    @Generated
    protected BaseQueryStorageTask(BaseQueryStorageTaskBuilder<?, ?> b) {
        super(b);
        this.deviceConfig = ((BaseQueryStorageTaskBuilder)b).deviceConfig;
        this.storageReqClient = ((BaseQueryStorageTaskBuilder)b).storageReqClient;
    }

    @Generated
    public static abstract class BaseQueryStorageTaskBuilder<C extends BaseQueryStorageTask, B extends BaseQueryStorageTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DeviceConfig deviceConfig;
        @Generated
        private StorageReqClient storageReqClient;

        @Generated
        public B deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return (B)this.self();
        }

        @Generated
        public B storageReqClient(StorageReqClient storageReqClient) {
            this.storageReqClient = storageReqClient;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseQueryStorageTask.BaseQueryStorageTaskBuilder(super=" + super.toString() + ", deviceConfig=" + this.deviceConfig + ", storageReqClient=" + this.storageReqClient + ")";
        }
    }
}

