/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.UserInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAccountTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateAccountTask.class);
    public static final String NAME_KEY = "config.interconnection.account";
    private static final String NUMBER_OF_SUPER_USERS_REACHED_UPPER_LIMIT = "The number of super users has reached the upper limit.";
    private final DeviceConfig deviceConfig;

    public void execute() throws TaskException {
        StorageReqClient storageReqClient = new StorageReqClient(this.deviceConfig.getDefaultIp(), this.deviceConfig.getUserName(), this.deviceConfig.getCurPassword());
        try {
            storageReqClient.login();
            this.appendTaskDetail("prepare to create user.");
            storageReqClient.createUser(this.deviceConfig.getEsn(), this.getReqParam(this.deviceConfig.getInterAccount()));
            this.appendTaskDetail("create user successfully.");
        }
        catch (DeployException deployException) {
            log.error("Create Account Task failed:", (Throwable)((Object)deployException));
            if (deployException.getErrorMessage().contains(NUMBER_OF_SUPER_USERS_REACHED_UPPER_LIMIT)) {
                throw new DeployException(StorageDeployError.NUMBER_OF_USERS_UPPER_LIMIT);
            }
            throw deployException;
        }
        finally {
            storageReqClient.logout(this.deviceConfig.getEsn());
        }
    }

    private Map<String, Object> getReqParam(UserInfo userInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NAME", userInfo.getUserName());
        map.put("ROLEID", userInfo.getRoleId());
        map.put("PASSWORD", userInfo.getCurPassword());
        map.put("SCOPE", userInfo.getScope());
        return map;
    }

    @Generated
    protected CreateAccountTask(CreateAccountTaskBuilder<?, ?> b) {
        super(b);
        this.deviceConfig = ((CreateAccountTaskBuilder)b).deviceConfig;
    }

    @Generated
    public static CreateAccountTaskBuilder<?, ?> builder() {
        return new CreateAccountTaskBuilderImpl();
    }

    @Generated
    private static final class CreateAccountTaskBuilderImpl
    extends CreateAccountTaskBuilder<CreateAccountTask, CreateAccountTaskBuilderImpl> {
        @Generated
        private CreateAccountTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateAccountTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateAccountTask build() {
            return new CreateAccountTask(this);
        }
    }

    @Generated
    public static abstract class CreateAccountTaskBuilder<C extends CreateAccountTask, B extends CreateAccountTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DeviceConfig deviceConfig;

        @Generated
        public B deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "CreateAccountTask.CreateAccountTaskBuilder(super=" + super.toString() + ", deviceConfig=" + this.deviceConfig + ")";
        }
    }
}

