/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.utils.LicenseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseTask.class);
    public static final String NAME_KEY = "config.license";
    private DeviceConfig deviceConfig;
    private StorageReqClient storageReqClient;

    public void execute() throws TaskException {
        this.storageReqClient = new StorageReqClient(this.deviceConfig.getDefaultIp(), this.deviceConfig.getUserName(), this.deviceConfig.getCurPassword());
        try {
            this.appendTaskDetail("prepare to upload and activate license.");
            this.storageReqClient.login();
            this.deployConfig(this.deviceConfig);
            this.appendTaskDetail("finish to upload and activate license.");
        }
        finally {
            this.storageReqClient.logout(this.deviceConfig.getEsn());
        }
    }

    private void deployConfig(DeviceConfig config) throws DeployException {
        File license = new File(config.getLicense().getLicensePath());
        Optional<String> licenseEsnOp = LicenseUtils.querySnInLicense(license);
        if (!licenseEsnOp.isPresent()) {
            log.error("license file is not exist.");
            throw new DeployException(StorageDeployError.LICENSE_NOT_EXIST_ERROR);
        }
        String licenseEsn = licenseEsnOp.get();
        this.appendTaskDetail("parse license file esn : " + licenseEsn);
        if (!Objects.equals(licenseEsn, this.deviceConfig.getEsn())) {
            log.error("license file is not match storage. license esn:{},device esn:{}", (Object)licenseEsn, (Object)this.deviceConfig.getEsn());
            throw new DeployException(StorageDeployError.LICENSE_NOT_MATCH_ERROR);
        }
        this.appendTaskDetail("start to upload license.");
        this.uploadLicense(config);
        this.queryLicenseUploadStatus(config);
        this.appendTaskDetail("start to activate license.");
        this.activateLicense(config);
    }

    private void activateLicense(DeviceConfig config) throws DeployException {
        Object result = this.storageReqClient.activateLicense(config.getEsn());
        JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)result));
        String activateResult = data.getString("LicenseActiveResult");
        if (StringUtils.equals((CharSequence)activateResult, (CharSequence)"0.0")) {
            log.info("activateResult, {}, success", (Object)activateResult);
            config.getLicense().setActivateStatus(true);
            return;
        }
        throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
    }

    private void queryLicenseUploadStatus(DeviceConfig config) throws DeployException {
        this.storageReqClient.queryLicenseUploadStatus(config.getEsn());
    }

    private void uploadLicense(DeviceConfig config) throws DeployException {
        log.info("start upload license: {}", (Object)config.getLicense().getLicensePath());
        boolean result = this.storageReqClient.uploadLicense(config.getEsn(), new File(config.getLicense().getLicensePath()));
        if (!result) {
            throw new DeployException(StorageDeployError.LICENSE_UPLOAD_FAIL);
        }
    }

    @Generated
    protected LicenseTask(LicenseTaskBuilder<?, ?> b) {
        super(b);
        this.deviceConfig = ((LicenseTaskBuilder)b).deviceConfig;
        this.storageReqClient = ((LicenseTaskBuilder)b).storageReqClient;
    }

    @Generated
    public static LicenseTaskBuilder<?, ?> builder() {
        return new LicenseTaskBuilderImpl();
    }

    @Generated
    private static final class LicenseTaskBuilderImpl
    extends LicenseTaskBuilder<LicenseTask, LicenseTaskBuilderImpl> {
        @Generated
        private LicenseTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected LicenseTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LicenseTask build() {
            return new LicenseTask(this);
        }
    }

    @Generated
    public static abstract class LicenseTaskBuilder<C extends LicenseTask, B extends LicenseTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DeviceConfig deviceConfig;
        @Generated
        private StorageReqClient storageReqClient;

        @Generated
        public B deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return (B)this.self();
        }

        @Generated
        public B storageReqClient(StorageReqClient storageReqClient) {
            this.storageReqClient = storageReqClient;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LicenseTask.LicenseTaskBuilder(super=" + super.toString() + ", deviceConfig=" + this.deviceConfig + ", storageReqClient=" + this.storageReqClient + ")";
        }
    }
}

