/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.LogicPort;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.PortType;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.ReqBody;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicPortTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicPortTask.class);
    public static final String NAME_KEY = "config.logic.port";
    private static final int FAILOVER_GROUP_TYPE = 289;
    private static final String FAILOVER_GROUP_NAME = "FailoverGroup_A3000_001";
    private final DeviceConfig deviceConfig;
    private final Map<String, String> portMap;
    private StorageReqClient storageReqClient;

    public void execute() throws TaskException {
        this.storageReqClient = new StorageReqClient(this.deviceConfig.getDefaultIp(), this.deviceConfig.getUserName(), this.deviceConfig.getCurPassword());
        try {
            this.appendTaskDetail("prepare to create logic ports.");
            this.storageReqClient.login();
            this.deployConfig(this.deviceConfig);
            this.appendTaskDetail("finish to create logic ports.");
        }
        finally {
            this.storageReqClient.logout(this.deviceConfig.getEsn());
        }
    }

    private void deployConfig(DeviceConfig config) throws DeployException {
        this.queryPortIds(this.storageReqClient.queryEthPort(config.getEsn()), config);
        this.appendTaskDetail("start to create bond ports.");
        this.createBondPorts(config);
        this.appendTaskDetail("start to create logic ports.");
        this.createLogicPort(config);
        this.appendTaskDetail("start to create failover groups.");
        this.createFailoverGroups(config);
    }

    private void createFailoverGroups(DeviceConfig config) {
        List<LogicPort> logicPorts = config.getLogicPort().getLogicPort();
        if (logicPorts.size() == 1) {
            log.info("current logic port size is 1.Logical ports do not need to be created.");
            return;
        }
        this.createVlanFailoverGroups(config);
        this.associatedPort(config);
    }

    private void associatedPort(DeviceConfig deviceConfig) {
        for (LogicPort logicPort : deviceConfig.getLogicPort().getLogicPort()) {
            this.storageReqClient.associateFailoverGroup(deviceConfig.getEsn(), this.getAssociateFailoverGroupParam(logicPort));
        }
    }

    private Map<String, Object> getAssociateFailoverGroupParam(LogicPort logicPort) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ASSOCIATEOBJTYPE", logicPort.getPortType().getFailoverGroupTypeId());
        map.put("ASSOCIATEOBJID", this.getHomePortId(logicPort));
        map.put("ID", this.portMap.get(FAILOVER_GROUP_NAME));
        map.put("TYPE", 289);
        return map;
    }

    private void createVlanFailoverGroups(DeviceConfig deviceConfig) {
        Object responseInfo = this.storageReqClient.createFailoverGroup(deviceConfig.getEsn(), this.getFailoverGroupParam());
        JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)responseInfo));
        this.portMap.put(FAILOVER_GROUP_NAME, data.getString("ID"));
    }

    private Map<String, Object> getFailoverGroupParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TYPE", 289);
        map.put("FAILOVERGROUPTYPE", "3");
        map.put("NAME", FAILOVER_GROUP_NAME);
        map.put("DESCRIPTION", "");
        return map;
    }

    private void createBondPorts(DeviceConfig config) throws DeployException {
        if (Objects.isNull(config.getLogicPort().getBondPorts()) || config.getLogicPort().getBondPorts().isEmpty()) {
            log.info("band ports is empty.");
            return;
        }
        for (BondPort bondPort : config.getLogicPort().getBondPorts()) {
            Object responseInfo = this.storageReqClient.createBondPort(config.getEsn(), this.getBondPortReqParam(bondPort));
            JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)responseInfo));
            this.portMap.put(bondPort.getName(), data.getString("ID"));
        }
    }

    private void createLogicPort(DeviceConfig config) throws DeployException {
        List<LogicPort> logicPort = config.getLogicPort().getLogicPort();
        if (logicPort.isEmpty()) {
            log.info("logic ports is empty");
            return;
        }
        for (LogicPort singleLogicPort : logicPort) {
            if (singleLogicPort.getPortType() == PortType.VLAN) {
                this.createSingleVlan(config, singleLogicPort);
            }
            this.storageReqClient.createLogicPort(config.getEsn(), this.getReqParam(singleLogicPort));
        }
        log.info("create Logic Port successfully.");
    }

    private void createSingleVlan(DeviceConfig config, LogicPort singleLogicPort) throws DeployException {
        Map<String, Object> param = this.getVlanParam(singleLogicPort);
        Object result = this.storageReqClient.createVlan(config.getEsn(), param);
        JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)result));
        singleLogicPort.getVlan().setId(data.getString("ID"));
    }

    @NotNull
    private Map<String, Object> getVlanParam(LogicPort singleLogicPort) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PORTTYPE", singleLogicPort.getVlan().getPortType().getId());
        param.put("TAG", Convert.toInt((Object)singleLogicPort.getVlan().getTag()));
        param.put("PORTID", this.portMap.get(singleLogicPort.getVlan().getPort()));
        return param;
    }

    private Map<String, Object> getReqParam(LogicPort logicPort) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SUPPORTPROTOCOL", logicPort.getDataProtocol().getValue());
        map.put("ROLE", 2);
        map.put("HOMEPORTTYPE", logicPort.getPortType().getId());
        map.put("HOMEPORTID", this.getHomePortId(logicPort));
        map.put("NAME", logicPort.getName());
        map.put("ADDRESSFAMILY", 0);
        map.put("IPV4ADDR", logicPort.getIp());
        map.put("IPV4MASK", logicPort.getSubnetMask());
        ReqBody.putIfNotEmpty(map, "IPV4GATEWAY", logicPort.getGateway());
        return map;
    }

    private String getHomePortId(LogicPort logicPort) {
        if (logicPort.getPortType() == PortType.ETH_PORT) {
            return this.portMap.get(logicPort.getLocation());
        }
        if (logicPort.getPortType() == PortType.BOND_PORT) {
            return this.portMap.get(logicPort.getBondPort().getName());
        }
        if (logicPort.getPortType() == PortType.VLAN) {
            return logicPort.getVlan().getId();
        }
        return "";
    }

    private Map<String, Object> getBondPortReqParam(BondPort bondPort) {
        List portIds = bondPort.getPorts().stream().filter(this.portMap::containsKey).map(this.portMap::get).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PORTIDLIST", portIds);
        map.put("NAME", bondPort.getName());
        return map;
    }

    private void queryPortIds(Object result, DeviceConfig config) throws DeployException {
        log.info("query logic port id.");
        JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)result));
        List<LogicPort> logicPort = config.getLogicPort().getLogicPort();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject cur = data.getJSONObject(i);
            if (!"0".equals(cur.getString("LOGICTYPE"))) continue;
            String location = cur.getString("LOCATION");
            String id = cur.getString("ID");
            logicPort.stream().filter(singleLogicPort -> singleLogicPort.getLocation().equals(location)).findFirst().ifPresent(singleLogicPort -> singleLogicPort.setRocePortId(id));
            this.portMap.put(location, id);
        }
    }

    @Generated
    private static Map<String, String> $default$portMap() {
        return new HashMap<String, String>();
    }

    @Generated
    protected LogicPortTask(LogicPortTaskBuilder<?, ?> b) {
        super(b);
        this.deviceConfig = ((LogicPortTaskBuilder)b).deviceConfig;
        this.portMap = ((LogicPortTaskBuilder)b).portMap$set ? ((LogicPortTaskBuilder)b).portMap$value : LogicPortTask.$default$portMap();
        this.storageReqClient = ((LogicPortTaskBuilder)b).storageReqClient;
    }

    @Generated
    public static LogicPortTaskBuilder<?, ?> builder() {
        return new LogicPortTaskBuilderImpl();
    }

    @Generated
    private static final class LogicPortTaskBuilderImpl
    extends LogicPortTaskBuilder<LogicPortTask, LogicPortTaskBuilderImpl> {
        @Generated
        private LogicPortTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected LogicPortTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LogicPortTask build() {
            return new LogicPortTask(this);
        }
    }

    @Generated
    public static abstract class LogicPortTaskBuilder<C extends LogicPortTask, B extends LogicPortTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DeviceConfig deviceConfig;
        @Generated
        private boolean portMap$set;
        @Generated
        private Map<String, String> portMap$value;
        @Generated
        private StorageReqClient storageReqClient;

        @Generated
        public B deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return (B)this.self();
        }

        @Generated
        public B portMap(Map<String, String> portMap) {
            this.portMap$value = portMap;
            this.portMap$set = true;
            return (B)this.self();
        }

        @Generated
        public B storageReqClient(StorageReqClient storageReqClient) {
            this.storageReqClient = storageReqClient;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LogicPortTask.LogicPortTaskBuilder(super=" + super.toString() + ", deviceConfig=" + this.deviceConfig + ", portMap$value=" + this.portMap$value + ", storageReqClient=" + this.storageReqClient + ")";
        }
    }
}

