/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.IpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.ReqBody;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyManageIpTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyManageIpTask.class);
    public static final String NAME_KEY = "config.manage.ip";
    private static final String MANAGE_PORT = "2";
    private final DeviceConfig deviceConfig;
    private StorageReqClient storageReqClient;

    public void execute() throws TaskException {
        this.storageReqClient = new StorageReqClient(this.deviceConfig.getDefaultIp(), this.deviceConfig.getUserName(), this.deviceConfig.getCurPassword());
        try {
            this.storageReqClient.login();
            this.deployConfig(this.deviceConfig);
        }
        finally {
            this.storageReqClient.logout(this.deviceConfig.getEsn());
        }
    }

    void deployConfig(DeviceConfig config) throws DeployException {
        Map<String, IpAndLocation> ipAndLocation = this.getIpAndLocation(config);
        if (Objects.requireNonNull(ipAndLocation).isEmpty()) {
            log.info("ip and location is empty.");
            return;
        }
        if (ipAndLocation.size() < 2) {
            log.error("query manager ip number is less 2");
            throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
        }
        Optional<IpAndLocation> curCtrlOptional = ipAndLocation.values().stream().filter(info -> config.getDefaultIp().equals(((IpAndLocation)info).ip)).findFirst();
        if (!curCtrlOptional.isPresent()) {
            log.error("query cur ip {} ctrl fail.", (Object)config.getDefaultIp());
            throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
        }
        this.sendModifyManagerIp(config, ipAndLocation, curCtrlOptional.get());
    }

    @Nullable
    private Map<String, IpAndLocation> getIpAndLocation(DeviceConfig config) {
        return this.parseManagerIpAndId(config, this.storageReqClient.queryEthPort(config.getEsn()));
    }

    @NotNull
    private Map<String, IpAndLocation> parseManagerIpAndId(DeviceConfig config, Object responseInfo) throws DeployException {
        JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)responseInfo));
        HashMap<String, IpAndLocation> managerIpAndId = new HashMap<String, IpAndLocation>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            JSONObject cur = data.getJSONObject(i);
            if (!MANAGE_PORT.equals(cur.getString("LOGICTYPE"))) continue;
            IpAndLocation ipAndLocation = new IpAndLocation();
            ipAndLocation.location = cur.getString("LOCATION");
            ipAndLocation.id = cur.getString("ID");
            ipAndLocation.ip = cur.getString("IPV4ADDR");
            managerIpAndId.put(ipAndLocation.location, ipAndLocation);
        }
        if (managerIpAndId.isEmpty()) {
            log.warn("{} not have manager port", (Object)config.getEsn());
            throw new DeployException(StorageDeployError.PARAM_ERROR);
        }
        return managerIpAndId;
    }

    private void sendModifyManagerIp(DeviceConfig config, Map<String, IpAndLocation> ipAndLocation, IpAndLocation curCtrlInfo) throws DeployException {
        IpAndLocation ctrlA = ipAndLocation.get("CTE0.A.MGMT");
        IpAndLocation ctrlB = ipAndLocation.get("CTE0.B.MGMT");
        if (curCtrlInfo.location.contains("A")) {
            this.modifyCtrlIp(config, ctrlB, config.getIpConfig().getCtrlBIp(), false);
            this.modifyCtrlIp(config, ctrlA, config.getIpConfig().getCtrlAIp(), true);
        } else {
            this.modifyCtrlIp(config, ctrlA, config.getIpConfig().getCtrlAIp(), false);
            this.modifyCtrlIp(config, ctrlB, config.getIpConfig().getCtrlBIp(), true);
        }
        this.updateDefaultIp(config, ctrlA, ctrlB);
    }

    private void modifyCtrlIp(DeviceConfig config, IpAndLocation ipAndLocation, String targetIp, boolean async) throws DeployException {
        IpConfig ipConfig = config.getIpConfig();
        if (StringUtils.isBlank((CharSequence)targetIp)) {
            log.info("ctrl ip is blank, not need modify");
            return;
        }
        log.info("will modify ip {} to {}", (Object)ipAndLocation.ip, (Object)targetIp);
        Map<String, Object> param = ModifyManageIpTask.getReqParam(ipConfig, targetIp);
        if (async) {
            this.asyncModifyManagerIp(ipAndLocation.id, param);
        } else {
            this.sendModifyManagerIp(ipAndLocation.id, param);
        }
    }

    private static Map<String, Object> getReqParam(IpConfig ipConfig, String ip) {
        HashMap<String, Object> reqJsonBody = new HashMap<String, Object>();
        ReqBody.putIfNotEmpty(reqJsonBody, "IPV4ADDR", ip);
        ReqBody.putIfNotEmpty(reqJsonBody, "IPV4MASK", ipConfig.getSubnetMask());
        ReqBody.putIfNotEmpty(reqJsonBody, "IPV4GATEWAY", ipConfig.getIpv4GateWay());
        return reqJsonBody;
    }

    private void asyncModifyManagerIp(String ethId, Map<String, Object> param) {
        CompletableFuture.runAsync(() -> {
            try {
                this.sendModifyManagerIp(ethId, param);
            }
            catch (DeployException e) {
                log.error("execute manager ip error.", (Throwable)((Object)e));
            }
        });
    }

    private void sendModifyManagerIp(String ethId, Map<String, Object> param) {
        this.storageReqClient.modifyManagerIp(this.deviceConfig.getEsn(), ethId, param);
        log.info("{} modify ip to {} success", (Object)this.deviceConfig.getEsn(), param);
    }

    private void updateDefaultIp(DeviceConfig config, IpAndLocation ctrlA, IpAndLocation ctrlB) {
        config.setModifyIp(true);
        String ctrlAIp = config.getIpConfig().getCtrlAIp();
        String ctrlBIp = config.getIpConfig().getCtrlBIp();
        if (StringUtils.isBlank((CharSequence)ctrlAIp)) {
            ctrlAIp = ctrlA.ip;
        }
        if (StringUtils.isBlank((CharSequence)ctrlBIp)) {
            ctrlBIp = ctrlB.ip;
        }
        this.updateDefaultIp(config, ctrlAIp, ctrlBIp);
    }

    private void updateDefaultIp(DeviceConfig config, String ctrlAIp, String ctrlBIp) {
        String defaultIp = config.getDefaultIp();
        if (StringUtils.equalsAny((CharSequence)defaultIp, (CharSequence[])new CharSequence[]{ctrlAIp, ctrlBIp})) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)ctrlAIp) && !StringUtils.equals((CharSequence)defaultIp, (CharSequence)ctrlAIp)) {
            config.setDefaultIp(ctrlAIp);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)ctrlBIp) && !StringUtils.equals((CharSequence)defaultIp, (CharSequence)ctrlBIp)) {
            config.setDefaultIp(ctrlAIp);
        }
    }

    @Generated
    protected ModifyManageIpTask(ModifyManageIpTaskBuilder<?, ?> b) {
        super(b);
        this.deviceConfig = ((ModifyManageIpTaskBuilder)b).deviceConfig;
        this.storageReqClient = ((ModifyManageIpTaskBuilder)b).storageReqClient;
    }

    @Generated
    public static ModifyManageIpTaskBuilder<?, ?> builder() {
        return new ModifyManageIpTaskBuilderImpl();
    }

    @Generated
    private static final class ModifyManageIpTaskBuilderImpl
    extends ModifyManageIpTaskBuilder<ModifyManageIpTask, ModifyManageIpTaskBuilderImpl> {
        @Generated
        private ModifyManageIpTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ModifyManageIpTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModifyManageIpTask build() {
            return new ModifyManageIpTask(this);
        }
    }

    @Generated
    public static abstract class ModifyManageIpTaskBuilder<C extends ModifyManageIpTask, B extends ModifyManageIpTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private DeviceConfig deviceConfig;
        @Generated
        private StorageReqClient storageReqClient;

        @Generated
        public B deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return (B)this.self();
        }

        @Generated
        public B storageReqClient(StorageReqClient storageReqClient) {
            this.storageReqClient = storageReqClient;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ModifyManageIpTask.ModifyManageIpTaskBuilder(super=" + super.toString() + ", deviceConfig=" + this.deviceConfig + ", storageReqClient=" + this.storageReqClient + ")";
        }
    }

    private static class IpAndLocation {
        private String ip;
        private String location;
        private String id;

        private IpAndLocation() {
        }
    }
}

