/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.StoragePoolConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.rest.StorageReqClient;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.task.subtask.BaseQueryStorageTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePoolTask
extends BaseQueryStorageTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StoragePoolTask.class);
    public static final String NAME_KEY = "config.storage.pool";

    public void execute() throws TaskException {
        this.storageReqClient = new StorageReqClient(this.deviceConfig.getDefaultIp(), this.deviceConfig.getUserName(), this.deviceConfig.getCurPassword());
        try {
            this.appendTaskDetail("prepare to create storage pool.");
            this.storageReqClient.login();
            this.deployConfig(this.deviceConfig);
            this.appendTaskDetail("finish to create storage pool.");
        }
        finally {
            this.storageReqClient.logout(this.deviceConfig.getEsn());
        }
    }

    private void deployConfig(DeviceConfig config) throws DeployException {
        this.handleResponse(config, this.storageReqClient.queryStoragePool(config.getEsn()));
    }

    private void handleResponse(DeviceConfig config, Object responseInfo) throws DeployException {
        if (this.isStoragePoolExist(config, responseInfo)) {
            log.info("storage pool is exist.");
            this.appendTaskDetail("storage pool is existed.");
            return;
        }
        for (Map<String, Object> createParam : this.getCreatePoolParam(config)) {
            this.appendTaskDetail("start to create storage pool, name : " + createParam.get("name"));
            Object content = this.storageReqClient.createStoragePool(createParam);
            this.appendTaskDetail("start to query task progress.");
            this.queryTask(content);
        }
        this.queryStoragePoolId(config);
    }

    private void queryStoragePoolId(DeviceConfig config) throws DeployException {
        Object result = this.storageReqClient.queryStoragePool(config.getEsn());
        if (this.setStorageId(config, result)) {
            return;
        }
        throw new DeployException(StorageDeployError.SEND_REQ_ERROR);
    }

    private boolean setStorageId(DeviceConfig config, Object result) {
        JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)result));
        if (data.isEmpty()) {
            return false;
        }
        JSONObject single = data.getJSONObject(0);
        String id = single.getString("ID");
        config.getStoragePoolConfig().setStoragePoolId(id);
        config.getStoragePoolConfig().setSpareCapacity(single.getLong("USERFREECAPACITY"));
        return true;
    }

    private List<Map<String, Object>> getCreatePoolParam(DeviceConfig config) {
        return Collections.singletonList(this.creatPoolParam(config));
    }

    private Map<String, Object> creatPoolParam(DeviceConfig config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", config.getStoragePoolConfig().getName());
        map.put("raidLevel", config.getStoragePoolConfig().getRaidLevel());
        map.put("raidMemberNumber", config.getStoragePoolConfig().getRaidMemberNum());
        map.put("SSDHOTSPARESTRATEGY", config.getStoragePoolConfig().getHotSparePolicy());
        map.put("engineIdList", config.getStoragePoolConfig().getEngineIds());
        map.put("TIER0DISKTYPE", "3");
        map.put("userConsumedCapacityThreshold", this.getUserConsumedCapacityThreshold(config.getStoragePoolConfig()));
        map.put("disks", this.getDisksMap(config));
        return map;
    }

    @NotNull
    private Map<String, Object> getDisksMap(DeviceConfig config) {
        HashMap<String, Object> disks = new HashMap<String, Object>();
        List<String> diskNums = config.getStoragePoolConfig().getDiskNums();
        if (Objects.isNull(diskNums) || diskNums.isEmpty()) {
            disks.put("all", true);
            return disks;
        }
        disks.put("byNumber", this.getByNumberMap(config));
        return disks;
    }

    @NotNull
    private Map<String, Object> getByNumberMap(DeviceConfig config) {
        HashMap<String, Object> byNumber = new HashMap<String, Object>();
        byNumber.put("diskNumList", config.getStoragePoolConfig().getDiskNums());
        byNumber.put("diskCapacity", config.getStoragePoolConfig().queryTransferDiskCapacity());
        return byNumber;
    }

    @NotNull
    private Map<String, Object> getUserConsumedCapacityThreshold(StoragePoolConfig storagePoolConfig) {
        HashMap<String, Object> userConsumedCapacityThreshold = new HashMap<String, Object>();
        userConsumedCapacityThreshold.put("level1", storagePoolConfig.getCapacityAlarmThreshold());
        userConsumedCapacityThreshold.put("level2", storagePoolConfig.getCapacityUsedUpAlarmThreshold());
        return userConsumedCapacityThreshold;
    }

    private boolean isStoragePoolExist(DeviceConfig config, Object responseInfo) {
        this.updateStoragePoolId(config, responseInfo);
        return StringUtils.isNotEmpty((CharSequence)config.getStoragePoolConfig().getStoragePoolId());
    }

    private void updateStoragePoolId(DeviceConfig config, Object content) throws DeployException {
        JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)content));
        if (!data.isEmpty()) {
            JSONObject single = data.getJSONObject(0);
            String id = single.getString("ID");
            log.info("exit storage pool, pool Id is {}", (Object)id);
            config.getStoragePoolConfig().setStoragePoolId(id);
            config.getStoragePoolConfig().setSpareCapacity(single.getLong("USERFREECAPACITY"));
            throw new DeployException(StorageDeployError.STORAGE_POOL_IS_EXIST);
        }
    }

    @Generated
    protected StoragePoolTask(StoragePoolTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static StoragePoolTaskBuilder<?, ?> builder() {
        return new StoragePoolTaskBuilderImpl();
    }

    @Generated
    private static final class StoragePoolTaskBuilderImpl
    extends StoragePoolTaskBuilder<StoragePoolTask, StoragePoolTaskBuilderImpl> {
        @Generated
        private StoragePoolTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected StoragePoolTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StoragePoolTask build() {
            return new StoragePoolTask(this);
        }
    }

    @Generated
    public static abstract class StoragePoolTaskBuilder<C extends StoragePoolTask, B extends StoragePoolTaskBuilder<C, B>>
    extends BaseQueryStorageTask.BaseQueryStorageTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "StoragePoolTask.StoragePoolTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

