/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client;

import com.huawei.smartkit.drop.util.sensitive.SensitiveUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.BaseClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.bind.cmd.BindHostParam;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.FcApiConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.FcRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRule;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRuleBind;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.cmd.CreateAlarmThresholdRule;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStoreQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.FileQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.FileUnit;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.ApplyUploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.UploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.cmd.UploadFile;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.port.HostPort;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.kms.AkSk;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.kms.cmd.AkDetailListQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.kms.cmd.AkSkCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.kms.cmd.AkSkReset;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.dvswitch.DvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.dvswitch.cmd.CreateDvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.cmd.CreatePortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.snmp.SnmpInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsVersions;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TaskDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TaskQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TemplateTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.UserCreateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.UserLogin;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.cmd.ActivateUser;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.cmd.InterconnectionUser;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.AttachImage;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.CreateVm;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.RebootVm;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmClone;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.VmBootOption;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.disk.AttachDisk;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.TemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ImportTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ParseTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.serverlease.ServerLeaseResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.serverlease.cmd.ServerLeaseComplete;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class ApiClientImpl
extends BaseClient
implements ApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiClientImpl.class);
    private final FcRequestApi vmRequestApi;

    @Override
    public String login(UserLogin user) {
        Map<String, String> headers = user.toMap();
        try {
            Response userInfoResponse = this.vmRequestApi.login(headers).execute();
            FcRequestUtils.dealResponse(userInfoResponse);
            String string = userInfoResponse.headers().get("X-Auth-Token");
            return string;
        }
        catch (IOException exception) {
            log.error("login error", (Throwable)exception);
            throw new FcTaskException(ApiError.LOGIN_FAIL, new Object[0]);
        }
        finally {
            SensitiveUtils.cleanStr((String)headers.get("X-Auth-Key"));
        }
    }

    @Override
    public Site getSite() {
        List sites = this.queryList(this.vmRequestApi::getSites);
        if (CollectionUtils.isEmpty(sites)) {
            throw new FcTaskException(ApiError.DATA_ERROR, new Object[0]);
        }
        return (Site)sites.get(0);
    }

    @Override
    public List<Host> getAllHost() {
        return this.queryList(this.vmRequestApi::getHosts);
    }

    @Override
    public List<HostPort> getHostPorts(String hostId) {
        return this.queryList(() -> this.vmRequestApi.getHostPorts(hostId));
    }

    @Override
    public List<DataStore> getDataStores(String hostUrn) {
        List<String> supportDataStoreTypes = FcConfigUtils.getDataStoreTypes();
        return this.queryList(() -> this.vmRequestApi.getDataStores(new DataStoreQuery(hostUrn).toMap())).stream().filter(DataStore::isAvailableStatus).filter(dataStore -> supportDataStoreTypes.contains(dataStore.getStorageType())).collect(Collectors.toList());
    }

    @Override
    public List<DvSwitch> getDvSwitches() {
        List<DvSwitch> dvSwitchList = this.queryList(this.vmRequestApi::getDvSwitches);
        dvSwitchList.forEach(dvSwitch -> dvSwitch.setPortGroups(this.getPortGroups(dvSwitch.getId())));
        return dvSwitchList;
    }

    @Override
    public TaskResult createDvSwitches(CreateDvSwitch createDvSwitch) {
        return (TaskResult)this.query(() -> this.vmRequestApi.createDvSwitch(createDvSwitch));
    }

    @Override
    public String createPortGroup(String dvSwitchId, CreatePortGroup createPortGroup) {
        return this.query(() -> this.vmRequestApi.createPortGroup(dvSwitchId, createPortGroup), FcEntityBase::getUrn);
    }

    @Override
    public List<PortGroup> getPortGroups(String dvSwitchId) {
        return this.queryList(() -> this.vmRequestApi.getPortGroups(dvSwitchId));
    }

    @Override
    public String createVm(CreateVm vmConfig) {
        return this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.createVm(vmConfig), TaskResult::getTaskId)).getEntityId();
    }

    @Override
    public TaskDetail getTaskUntilSuccess(String taskId) {
        TaskDetail task = RetryUtils.retry(() -> this.getTaskById(taskId), TaskDetail::isFinish, 30);
        if (!task.isSuccess()) {
            throw new FcTaskException(ApiError.TASK_FAIL, task.getReasonDes());
        }
        return task;
    }

    @Override
    public TaskDetail getTaskById(String taskId) {
        return this.getTaskById(taskId, 0);
    }

    private TaskDetail getTaskById(String taskId, int count) {
        try {
            return (TaskDetail)this.query(() -> this.vmRequestApi.getTaskById(taskId));
        }
        catch (FcTaskException e) {
            if (ApiError.IO_ERROR.getKey().equals(e.getKey()) && ++count < 3) {
                log.error("getTaskById IO error, taskId:{}, count:{}", (Object)taskId, (Object)count);
                ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
                return this.getTaskById(taskId, count);
            }
            throw e;
        }
    }

    @Override
    public List<TaskDetail> getTasks(TaskQuery query) {
        return this.queryList(() -> this.vmRequestApi.getTasks(query.toMap()));
    }

    @Override
    public List<FileUnit> getImageFileList(String diskId) {
        return this.queryList(() -> this.vmRequestApi.getImageFileList(diskId, new FileQuery().toMap()));
    }

    @Override
    public FileUnit getImageFileInfo(String dataStoreId, String fileName) {
        return this.getImageFileList(dataStoreId).stream().filter(image -> image.getName().equals(fileName)).findFirst().orElseGet(() -> FileUnit.builder().fileId(0).build());
    }

    @Override
    public int getFileId(String dataStoreId, String fileName) {
        return this.getImageFileInfo(dataStoreId, fileName).getFileId();
    }

    @Override
    public void attachImage(String vmsId, AttachImage attachImage) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.attachImage(vmsId, attachImage), TaskResult::getTaskId));
    }

    @Override
    public void updateImageProperty(String vmsId, VmBootOption bootOption) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.updateVmProperty(vmsId, bootOption), TaskResult::getTaskId));
    }

    @Override
    public void rebootVm(String vmsId) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.rebootVm(vmsId, new RebootVm()), TaskResult::getTaskId));
    }

    @Override
    public ApplyUploadResponse applyUpload(String diskId, UploadFile uploadFile) {
        return (ApplyUploadResponse)this.query(() -> this.vmRequestApi.applyUpload(diskId, uploadFile.toMap()));
    }

    @Override
    public void authCna(String url) {
        this.execute(() -> this.vmRequestApi.authCna(url));
    }

    @Override
    public UploadResponse getStreamUpload(ApplyUploadResponse applyResponse, Map<String, String> queryMap) {
        return (UploadResponse)this.query(() -> this.vmRequestApi.getStreamUpload(applyResponse.getToken(), applyResponse.getUploadURL(), queryMap));
    }

    @Override
    public UploadResponse postStreamUpload(Map<String, String> headers, String url, byte[] slice, UploadFile uploadFile) {
        RequestBody requestBody = RequestBody.create((MediaType)FcApiConstant.MEDIA_TYPE_STREAM, (byte[])slice);
        return (UploadResponse)this.query(() -> this.vmRequestApi.postStreamUpload(headers, url, requestBody, uploadFile.toMap()));
    }

    @Override
    public boolean deleteVm(String vmsId) {
        try {
            return this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.deleteVm(vmsId), TaskResult::getTaskId)) != null;
        }
        catch (FcTaskException e) {
            log.warn("delete vm failed, vmdId : {}.", (Object)vmsId, (Object)e);
            return false;
        }
    }

    @Override
    public void deleteVmNic(String vmsId, String nicId) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.deleteVmNic(vmsId, nicId), TaskResult::getTaskId));
    }

    @Override
    public void detachImage(String vmsId) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.detachImage(vmsId), TaskResult::getTaskId));
    }

    @Override
    public void deleteFile(String datastoreId, int fileId) {
        try {
            FcRequestUtils.dealResponse(this.vmRequestApi.deleteFile(datastoreId, fileId).execute());
        }
        catch (IOException e) {
            log.error("deleteFile failed", (Throwable)e);
            throw new FcTaskException(ApiError.REQUEST_FAILED, new Object[0]);
        }
    }

    @Override
    public TemplateTaskResult importTemplate(ImportTemplate importTemplate) {
        return (TemplateTaskResult)this.query(() -> this.vmRequestApi.importTemplate(importTemplate));
    }

    @Override
    public TemplateInfo parseTemplate(ParseTemplate parseTemplate) {
        return (TemplateInfo)this.query(() -> this.vmRequestApi.parseTemplate(parseTemplate));
    }

    @Override
    public ServerLeaseResponse getServerLeaseInfo(String serverLeaseId) {
        return (ServerLeaseResponse)this.query(() -> this.vmRequestApi.getServerLeaseInfo(serverLeaseId));
    }

    @Override
    public void completeServerLease(String serverLeaseId) {
        this.execute(() -> this.vmRequestApi.completeServerLease(serverLeaseId, new ServerLeaseComplete()));
    }

    @Override
    public VmDetail getVmDetail(String vmsId) {
        return (VmDetail)this.query(() -> this.vmRequestApi.getVm(vmsId));
    }

    @Override
    public TaskResult cloneVm(String vmsId, VmClone vmClone) {
        return (TaskResult)this.query(() -> this.vmRequestApi.cloneVm(vmsId, vmClone));
    }

    @Override
    public TaskDetail startVm(String vmsId) {
        return this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.startVm(vmsId), TaskResult::getTaskId));
    }

    @Override
    public void customVm(String requestId) {
        this.getTasks(new TaskQuery("InjectCustomizationTask")).stream().filter(task -> Objects.equals(task.getRequestId(), requestId)).peek(task -> log.info("start to wait custom vm task, id : {}.", (Object)task.getId())).findFirst().ifPresent(task -> this.getTaskUntilSuccess(task.getId()));
    }

    @Override
    public OsVersions getOsVersions(OsQuery query) {
        return (OsVersions)this.query(() -> this.vmRequestApi.getOsVersions(query.toMap()));
    }

    @Override
    public List<PortGroup> getAllPortGroups() {
        List dvSwitches = this.queryList(this.vmRequestApi::getDvSwitches);
        return dvSwitches.stream().map(FcEntityBase::getId).flatMap(dvSwitchId -> this.queryList(() -> this.vmRequestApi.getPortGroups((String)dvSwitchId)).stream()).collect(Collectors.toList());
    }

    @Override
    public void attachDisk(String vmId, AttachDisk attachDisk) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.attachDisk(vmId, attachDisk), TaskResult::getTaskId));
    }

    @Override
    public void installTools(String vmId) {
        this.getTaskUntilSuccess(this.query(() -> this.vmRequestApi.installTools(vmId), TaskResult::getTaskId));
    }

    @Override
    public Optional<String> queryAkByName(String name) {
        return this.queryList(() -> this.vmRequestApi.queryAkSkList(new AkDetailListQuery(name))).stream().filter(akSk -> Objects.equals(akSk.getName(), name)).findFirst().map(AkSk::getAk);
    }

    @Override
    public AkSk createAkSk(String name) {
        return (AkSk)this.query(() -> this.vmRequestApi.createAkSk(new AkSkCreate(name)));
    }

    @Override
    public AkSk resetAkSk(String ak) {
        return (AkSk)this.query(() -> this.vmRequestApi.resetAkSk(new AkSkReset(ak)));
    }

    @Override
    public void unbindHost(String vmID, BindHostParam param) {
        this.execute(() -> this.vmRequestApi.bindHost(vmID, param));
    }

    @Override
    public UserCreateInfo createInterconnectionUser(InterconnectionUser interconnectionUser) {
        UserCreateInfo createInfo = (UserCreateInfo)this.query(() -> this.vmRequestApi.addInterconnectionUser(interconnectionUser));
        interconnectionUser.clear();
        return createInfo;
    }

    @Override
    public List<InterconnectionUser> queryAllUsers() {
        return this.queryList(this.vmRequestApi::queryAllUsers);
    }

    @Override
    public boolean containsUser(String username) {
        return this.queryAllUsers().stream().map(InterconnectionUser::getUserName).anyMatch(name -> Objects.equals(name, username));
    }

    @Override
    public void createSnmp(SnmpInfo snmpInfo) {
        this.execute(() -> this.vmRequestApi.addSnmp(snmpInfo));
        snmpInfo.clear();
    }

    @Override
    public List<SnmpInfo> queryAllSnmps() {
        return this.queryList(this.vmRequestApi::queryAllSnmps);
    }

    @Override
    public boolean containSnmp(String snmpMgrName, String userName) {
        return this.queryAllSnmps().stream().anyMatch(snmp -> snmp.isEqualSnmpUser(userName, snmpMgrName));
    }

    @Override
    public void activateUser(String userId, ActivateUser activateUser) {
        this.execute(() -> this.vmRequestApi.activateUserInThreeRole(userId, activateUser));
    }

    @Override
    public List<AlarmThresholdRule> queryAlarmThresholdRule(AlarmThresholdQuery query) {
        return this.queryList(() -> this.vmRequestApi.queryAlarmThresholdRule(query.toMap()));
    }

    @Override
    public void addAlarmThresholdRule(CreateAlarmThresholdRule thresholdRule) {
        this.execute(() -> this.vmRequestApi.addAlarmThresholdRule(thresholdRule));
    }

    @Override
    public void bindAlarmThresholdRule(AlarmThresholdRuleBind ruleBind) {
        this.execute(() -> this.vmRequestApi.bindAlarmThresholdRule(ruleBind));
    }

    @Generated
    public ApiClientImpl(FcRequestApi vmRequestApi) {
        this.vmRequestApi = vmRequestApi;
    }
}

