/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.DataList;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseClient.class);

    protected <T> T query(Query<T> query) {
        try {
            return (T)Optional.of(query.query().execute()).map(FcRequestUtils::dealResponse).orElseThrow(FcTaskException.thr(ApiError.DATA_ERROR));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new FcTaskException(ApiError.IO_ERROR, new Object[0]);
        }
    }

    protected <T> List<T> queryList(Query<DataList<T>> query) {
        return this.query(query, DataList::getData);
    }

    protected <T, R> R query(Query<T> query, Function<T, R> mapper) {
        try {
            return Optional.of(query.query().execute()).map(FcRequestUtils::dealResponse).map(mapper).orElseThrow(FcTaskException.thr(ApiError.DATA_ERROR));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new FcTaskException(ApiError.IO_ERROR, new Object[0]);
        }
    }

    protected void execute(Query<Void> execute) {
        try {
            FcRequestUtils.dealResponse(execute.query().execute());
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new FcTaskException(ApiError.IO_ERROR, new Object[0]);
        }
    }
}

