/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.net.cmd.PortGroupCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.CreateVmByImgCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.OsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.RouteInfoCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.cmd.CreatePortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsVersion;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.CreateVm;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.NicSpecification;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.RouteInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmClone;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmCustomization;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Cpu;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Disk;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.GraphicsCard;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Memory;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.OsOptions;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Property;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.TemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ImportTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ParseTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(imports={Collections.class, StringUtils.class})
public interface FcDataConverter {
    public CreatePortGroup toCreatePortGroup(PortGroupCmd var1);

    public ParseTemplate toParseCmd(String var1, String var2);

    @Mappings(value={@Mapping(target="name", source="cmd.templateName"), @Mapping(target="url", source="cmd"), @Mapping(target="location", source="host.urn")})
    public ImportTemplate toImportTemplate(UploadTemplateCmd var1, String var2, TemplateInfo var3, Host var4);

    default public String toUrl(UploadTemplateCmd cmd) {
        String path = cmd.getOvfFilePath() != null ? cmd.getOvfFilePath().get() : cmd.getFilePath().get();
        return new File(path).getName();
    }

    @Mappings(value={@Mapping(target="name", source="cmd.vmName"), @Mapping(target="isBindingHost", source="cmd.bindingHost"), @Mapping(target="vmCustomization", expression="java(toCustomization(cmd, vmDetail))"), @Mapping(target="parentObjUrn", source="context.site.urn"), @Mapping(target="location", expression="java(context.getHostByName(cmd.getCnaName()).getUrn())"), @Mapping(target="cpuVendor", expression="java(context.getHostByName(cmd.getCnaName()).getCpuVendor())"), @Mapping(target="isAutoBoot", expression="java(false)")})
    public VmClone buildVmClone(CreateVmByTemplateCmd var1, FcInfoContext var2, VmDetail var3);

    @Mappings(value={@Mapping(target="hostname", source="cmd.hostName"), @Mapping(target="osType", source="vmDetail.osOptions.osType"), @Mapping(target="nicSpecification", expression="java(toNic(cmd.getNicConfigs()))"), @Mapping(target="updatePassword", expression="java(StringUtils.isNotEmpty(cmd.getPassword()))")})
    public VmCustomization toCustomization(CreateVmByTemplateCmd var1, VmDetail var2);

    @Mapping(target="route4Infos", expression="java(toRouteInfoList(configCmd.getRouteInfo()))")
    public NicSpecification toNic(VmNicConfigCmd var1, int var2);

    default public List<RouteInfo> toRouteInfoList(RouteInfoCmd infoCmd) {
        return infoCmd == null ? Collections.emptyList() : Collections.singletonList(this.toRouteInfo(infoCmd));
    }

    public RouteInfo toRouteInfo(RouteInfoCmd var1);

    default public List<NicSpecification> toNic(List<VmNicConfigCmd> nicConfigs) {
        if (CollectionUtils.isEmpty(nicConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<NicSpecification> result = new ArrayList<NicSpecification>();
        for (int i = 0; i < nicConfigs.size(); ++i) {
            VmNicConfigCmd nicConfig = nicConfigs.get(i);
            result.add(this.toNic(nicConfig, i + 1));
        }
        return result;
    }

    @Mappings(value={@Mapping(target="osOptions", source="osVersion"), @Mapping(target="fileItems", expression="java(Collections.singletonList(new TemplateFileItem(imageFormat)))"), @Mapping(target="vmConfig", expression="java(toVmConfig(osVersion, taskContext))")})
    public TemplateInfo toTemplateInfo(OsVersion var1, TaskContext var2, String var3);

    default public VmConfig toVmConfig(OsVersion osVersion, TaskContext taskContext) {
        return this.toVmConfig(taskContext, osVersion.getDefaultCPUQuantity(), osVersion.getDefaultMemoryQuantity(), Collections.singletonList(osVersion.getDefaultSysVolQuantity()));
    }

    default public VmConfig toVmConfig(TaskContext taskContext, int cpu, int memorySizeMb, List<Integer> disks) {
        VmConfig config = new VmConfig();
        config.setCpu(Cpu.builder().quantity(cpu).weight(cpu * 500).build());
        config.setMemory(Memory.builder().quantityMB(memorySizeMb).weight(memorySizeMb * 10).build());
        if (CollectionUtils.isNotEmpty(disks)) {
            config.setDisks(IntStream.range(0, disks.size()).mapToObj(index -> new Disk(taskContext.getDataStore(), (Integer)disks.get(index), index + 1)).collect(Collectors.toList()));
        }
        config.setNics(Collections.singletonList(new Nic(taskContext.getPortGroup().getUrn(), 0)));
        boolean isArm = Optional.ofNullable(taskContext.getHost()).map(Host::getArch).map("arm"::equals).orElse(false);
        config.setGraphicsCard(new GraphicsCard(isArm));
        config.setProperties(new Property(isArm));
        return config;
    }

    @Mappings(value={@Mapping(target="name", source="cmd.vmName"), @Mapping(target="location", expression="java(taskContext.getHost().getUrn())"), @Mapping(target="cpuVendor", expression="java(taskContext.getHost().getCpuVendor())"), @Mapping(target="parentObjUrn", expression="java(FcInfoContext.get().getSite().getUrn())"), @Mapping(target="osOptions", source="osVersion"), @Mapping(target="vmConfig", expression="java(toVmConfig(taskContext, cmd.getCpuCores(), cmd.getMemorySizeGb() * 1024, cmd.getDisks()))")})
    public CreateVm toCreateVm(CreateVmByImgCmd var1, OsVersion var2, TaskContext var3);

    @Mappings(value={@Mapping(target="osVersion", source="id"), @Mapping(target="guestOSName", source="versionDes"), @Mapping(target="osType", expression="java(StringUtils.capitalize(osVersion.getOsType()))")})
    public OsOptions toOsOption(OsVersion var1);

    @Mapping(target="hostName", source="ip")
    public SshConnInfo toSShConnInfo(OsCmd var1);

    public OsQuery toOsQuery(Host var1);
}

